/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentCondition;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.kubernetes.KubernetesClusterClientFactory;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.highavailability.KubernetesHaServicesFactory;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.runtime.rest.messages.DashboardConfigurationHeaders;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String CR_GENERATION_LABEL = "flinkdeployment.flink.apache.org/generation";

    public static PodTemplateSpec mergePodTemplates(PodTemplateSpec toPod, PodTemplateSpec fromPod, boolean mergeArraysByName) {
        if (fromPod == null) {
            return ReconciliationUtils.clone(toPod);
        }
        if (toPod == null) {
            return ReconciliationUtils.clone(fromPod);
        }
        JsonNode node1 = MAPPER.valueToTree((Object)toPod);
        JsonNode node2 = MAPPER.valueToTree((Object)fromPod);
        FlinkUtils.mergeInto(node1, node2, mergeArraysByName);
        try {
            return (PodTemplateSpec)MAPPER.treeToValue((TreeNode)node1, PodTemplateSpec.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void mergeInto(JsonNode toNode, JsonNode fromNode, boolean mergeArraysByName) {
        Iterator fieldNames = fromNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode toChildNode = toNode.get(fieldName);
            JsonNode fromChildNode = fromNode.get(fieldName);
            if (toChildNode != null && toChildNode.isArray() && fromChildNode.isArray()) {
                FlinkUtils.mergeArray((ArrayNode)toChildNode, (ArrayNode)fromChildNode, mergeArraysByName);
                continue;
            }
            if (toChildNode != null && toChildNode.isObject()) {
                FlinkUtils.mergeInto(toChildNode, fromChildNode, mergeArraysByName);
                continue;
            }
            if (!(toNode instanceof ObjectNode)) continue;
            ((ObjectNode)toNode).replace(fieldName, fromChildNode);
        }
    }

    private static void mergeArray(ArrayNode toChildNode, ArrayNode fromChildNode, boolean mergeArraysByName) {
        if (FlinkUtils.namesDefined(toChildNode) && FlinkUtils.namesDefined(fromChildNode) && mergeArraysByName) {
            Map<String, ObjectNode> toGrouped = FlinkUtils.groupByName(toChildNode);
            Map<String, ObjectNode> fromGrouped = FlinkUtils.groupByName(fromChildNode);
            fromGrouped.forEach((name, fromElement) -> toGrouped.compute((String)name, (n, toElement) -> {
                if (toElement == null) {
                    return fromElement;
                }
                FlinkUtils.mergeInto((JsonNode)toElement, (JsonNode)fromElement, mergeArraysByName);
                return toElement;
            }));
            toChildNode.removeAll();
            toGrouped.values().forEach(arg_0 -> ((ArrayNode)toChildNode).add(arg_0));
        } else {
            for (int i = 0; i < fromChildNode.size(); ++i) {
                JsonNode updatedChildNode = fromChildNode.get(i);
                if (toChildNode.size() <= i) {
                    toChildNode.add(updatedChildNode);
                }
                FlinkUtils.mergeInto(toChildNode.get(i), updatedChildNode, mergeArraysByName);
            }
        }
    }

    private static boolean namesDefined(ArrayNode node) {
        Iterator it = node.elements();
        while (it.hasNext()) {
            JsonNode next = (JsonNode)it.next();
            if (next.has("name")) continue;
            return false;
        }
        return true;
    }

    private static Map<String, ObjectNode> groupByName(ArrayNode node) {
        LinkedHashMap<String, ObjectNode> out = new LinkedHashMap<String, ObjectNode>();
        node.elements().forEachRemaining(e -> out.put(e.get("name").asText(), (ObjectNode)e));
        return out;
    }

    public static void addStartupProbe(PodTemplateSpec pod) {
        Container mainContainer;
        ArrayList containers;
        PodSpec spec = pod.getSpec();
        if (spec == null) {
            spec = new PodSpec();
            pod.setSpec(spec);
        }
        if ((containers = spec.getContainers()) == null) {
            containers = new ArrayList();
            spec.setContainers(containers);
        }
        if ((mainContainer = containers.stream().filter(c -> "flink-main-container".equals(c.getName())).findAny().orElseGet(() -> {
            Container c = new Container();
            c.setName("flink-main-container");
            ArrayList<Container> containersCopy = new ArrayList<Container>(pod.getSpec().getContainers());
            containersCopy.add(c);
            pod.getSpec().setContainers(containersCopy);
            return c;
        })).getStartupProbe() == null) {
            Probe probe = new Probe();
            probe.setFailureThreshold(Integer.valueOf(Integer.MAX_VALUE));
            probe.setPeriodSeconds(Integer.valueOf(1));
            HTTPGetAction configGet = new HTTPGetAction();
            configGet.setPath(DashboardConfigurationHeaders.getInstance().getTargetRestEndpointURL());
            configGet.setPort(new IntOrString((Object)"rest"));
            probe.setHttpGet(configGet);
            mainContainer.setStartupProbe(probe);
        }
    }

    public static void deleteZookeeperHAMetadata(Configuration conf) {
        try (CuratorFrameworkWithUnhandledErrorListener curator = ZooKeeperUtils.startCuratorFramework((Configuration)conf, exception -> {});){
            try {
                curator.asCuratorFramework().delete().deletingChildrenIfNeeded().forPath("/");
            }
            catch (Exception e) {
                LOG.error("Could not delete HA Metadata at path {} in Zookeeper", (Object)ZooKeeperUtils.generateZookeeperPath((String[])new String[]{(String)conf.get(HighAvailabilityOptions.HA_ZOOKEEPER_ROOT), (String)conf.get(HighAvailabilityOptions.HA_CLUSTER_ID)}), (Object)e);
            }
        }
    }

    public static void deleteKubernetesHAMetadata(String clusterId, String namespace, KubernetesClient kubernetesClient) {
        ((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(namespace)).withLabels(KubernetesUtils.getConfigMapLabels((String)clusterId, (String)"high-availability"))).delete();
    }

    public static void deleteJobGraphInZookeeperHA(Configuration conf) throws Exception {
        try (CuratorFrameworkWithUnhandledErrorListener curator = ZooKeeperUtils.startCuratorFramework((Configuration)conf, exception -> {});){
            ZooKeeperUtils.deleteZNode((CuratorFramework)curator.asCuratorFramework(), (String)((String)conf.get(HighAvailabilityOptions.HA_ZOOKEEPER_JOBGRAPHS_PATH)));
        }
    }

    public static void deleteJobGraphInKubernetesHA(String clusterId, String namespace, KubernetesClient kubernetesClient) {
        Map haConfigMapLabels = KubernetesUtils.getConfigMapLabels((String)clusterId, (String)"high-availability");
        ConfigMapList configMaps = (ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(namespace)).withLabels(haConfigMapLabels)).list();
        boolean shouldUpdate = false;
        for (ConfigMap configMap : configMaps.getItems()) {
            boolean isDeleted;
            if (configMap.getData() == null || configMap.getData().isEmpty() || !(isDeleted = configMap.getData().entrySet().removeIf(FlinkUtils::isJobGraphKey))) continue;
            shouldUpdate = true;
            LOG.info("Job graph in ConfigMap {} is deleted", (Object)configMap.getMetadata().getName());
        }
        if (shouldUpdate) {
            ((ListVisitFromServerGetDeleteRecreateWaitApplicable)kubernetesClient.resourceList((KubernetesResourceList)configMaps).inNamespace(namespace)).createOrReplace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZookeeperHaMetadataAvailable(Configuration conf) {
        try (CuratorFrameworkWithUnhandledErrorListener curator = ZooKeeperUtils.startCuratorFramework((Configuration)conf, exception -> {});){
            if (curator.asCuratorFramework().checkExists().forPath(ZooKeeperUtils.getJobsPath()) != null) {
                boolean bl2 = ((List)curator.asCuratorFramework().getChildren().forPath(ZooKeeperUtils.getJobsPath())).size() != 0;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Could not check whether the HA metadata exists at path {} in Zookeeper", (Object)ZooKeeperUtils.generateZookeeperPath((String[])new String[]{(String)conf.get(HighAvailabilityOptions.HA_ZOOKEEPER_ROOT), (String)conf.get(HighAvailabilityOptions.HA_CLUSTER_ID), ZooKeeperUtils.getJobsPath()}), (Object)e);
            return false;
        }
    }

    public static boolean isKubernetesHaMetadataAvailable(Configuration conf, KubernetesClient kubernetesClient) {
        String clusterId = (String)conf.get(KubernetesConfigOptions.CLUSTER_ID);
        String namespace = (String)conf.get(KubernetesConfigOptions.NAMESPACE);
        Map haConfigMapLabels = KubernetesUtils.getConfigMapLabels((String)clusterId, (String)"high-availability");
        List configMaps = ((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(namespace)).withLabels(haConfigMapLabels)).list()).getItems();
        return configMaps.stream().anyMatch(FlinkUtils::isValidHaConfigMap);
    }

    private static boolean isValidHaConfigMap(ConfigMap cm) {
        if (cm.isMarkedForDeletion()) {
            return false;
        }
        String name = cm.getMetadata().getName();
        if (name.endsWith("-config-map")) {
            return !name.endsWith("-cluster-config-map");
        }
        return name.endsWith("-jobmanager-leader");
    }

    private static boolean isJobGraphKey(Map.Entry<String, String> entry) {
        return entry.getKey().startsWith("jobGraph-");
    }

    public static boolean isZookeeperHAActivated(Configuration configuration) {
        return HighAvailabilityMode.fromConfig((Configuration)configuration).equals((Object)HighAvailabilityMode.ZOOKEEPER);
    }

    public static boolean isKubernetesHAActivated(Configuration configuration) {
        String haMode = (String)configuration.get(HighAvailabilityOptions.HA_MODE);
        return haMode.equalsIgnoreCase(KubernetesHaServicesFactory.class.getCanonicalName()) || haMode.equalsIgnoreCase("kubernetes");
    }

    public static int getNumTaskManagers(Configuration conf) {
        int parallelism = (Integer)conf.get(CoreOptions.DEFAULT_PARALLELISM);
        return FlinkUtils.getNumTaskManagers(conf, parallelism);
    }

    public static int getNumTaskManagers(Configuration conf, int parallelism) {
        int taskSlots = (Integer)conf.get(TaskManagerOptions.NUM_TASK_SLOTS);
        return (parallelism + taskSlots - 1) / taskSlots;
    }

    public static Double calculateClusterCpuUsage(Configuration conf, int taskManagerReplicas) {
        double jmTotalCpu = conf.getDouble(KubernetesConfigOptions.JOB_MANAGER_CPU) * conf.getDouble(KubernetesConfigOptions.JOB_MANAGER_CPU_LIMIT_FACTOR) * (double)((Integer)conf.get(KubernetesConfigOptions.KUBERNETES_JOBMANAGER_REPLICAS)).intValue();
        double tmTotalCpu = conf.getDouble(KubernetesConfigOptions.TASK_MANAGER_CPU, 1.0) * conf.getDouble(KubernetesConfigOptions.TASK_MANAGER_CPU_LIMIT_FACTOR) * (double)taskManagerReplicas;
        return tmTotalCpu + jmTotalCpu;
    }

    public static Long calculateClusterMemoryUsage(Configuration conf, int taskManagerReplicas) {
        ClusterSpecification clusterSpec = new KubernetesClusterClientFactory().getClusterSpecification(conf);
        KubernetesJobManagerParameters jmParameters = new KubernetesJobManagerParameters(conf, clusterSpec);
        long jmTotalMemory = Math.round((double)jmParameters.getJobManagerMemoryMB() * Math.pow(1024.0, 2.0) * jmParameters.getJobManagerMemoryLimitFactor() * (double)jmParameters.getReplicas());
        long tmTotalMemory = Math.round((double)clusterSpec.getTaskManagerMemoryMB() * Math.pow(1024.0, 2.0) * conf.getDouble(KubernetesConfigOptions.TASK_MANAGER_MEMORY_LIMIT_FACTOR) * (double)taskManagerReplicas);
        return tmTotalMemory + jmTotalMemory;
    }

    public static void setGenerationAnnotation(Configuration conf, Long generation) {
        if (generation == null) {
            return;
        }
        HashMap<String, String> labels = new HashMap<String, String>(conf.getOptional(KubernetesConfigOptions.JOB_MANAGER_ANNOTATIONS).orElse(Collections.emptyMap()));
        labels.put(CR_GENERATION_LABEL, generation.toString());
        conf.set(KubernetesConfigOptions.JOB_MANAGER_ANNOTATIONS, labels);
    }

    public static boolean jmPodNeverStarted(Context<?> context) {
        Optional depOpt = context.getSecondaryResource(Deployment.class);
        if (depOpt.isPresent()) {
            Deployment deployment = (Deployment)depOpt.get();
            for (DeploymentCondition condition : deployment.getStatus().getConditions()) {
                if (!condition.getType().equals("Available")) continue;
                String createTs = deployment.getMetadata().getCreationTimestamp();
                if (!"False".equals(condition.getStatus()) || !createTs.equals(condition.getLastTransitionTime())) continue;
                return true;
            }
        }
        return false;
    }
}

