/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EventUtils.class);

    public static String generateEventName(HasMetadata target, EventRecorder.Type type, String reason, String message, EventRecorder.Component component) {
        return component + "." + ((reason + message + type + target.getKind() + target.getMetadata().getName() + target.getMetadata().getUid()).hashCode() & Integer.MAX_VALUE);
    }

    public static boolean createOrUpdateEventWithInterval(KubernetesClient client, HasMetadata target, EventRecorder.Type type, String reason, String message, EventRecorder.Component component, Consumer<Event> eventListener, @Nullable String messageKey, @Nullable Duration interval) {
        return EventUtils.createOrUpdateEventWithLabels(client, target, type, reason, message, component, eventListener, messageKey, interval, null, Map.of());
    }

    public static Event findExistingEvent(KubernetesClient client, HasMetadata target, String eventName) {
        return (Event)((Resource)((NonNamespaceOperation)client.v1().events().inNamespace(target.getMetadata().getNamespace())).withName(eventName)).get();
    }

    public static boolean createIfNotExists(KubernetesClient client, HasMetadata target, EventRecorder.Type type, String reason, String message, EventRecorder.Component component, Consumer<Event> eventListener, @Nullable String messageKey) {
        String eventName = EventUtils.generateEventName(target, type, reason, messageKey != null ? messageKey : message, component);
        Event existing = EventUtils.findExistingEvent(client, target, eventName);
        if (existing != null) {
            return false;
        }
        Event event = EventUtils.buildEvent(target, type, reason, message, component, eventName);
        EventUtils.createOrReplaceEvent(client, event).ifPresent(eventListener);
        return true;
    }

    public static boolean createOrUpdateEventWithLabels(KubernetesClient client, HasMetadata target, EventRecorder.Type type, String reason, String message, EventRecorder.Component component, Consumer<Event> eventListener, @Nullable String messageKey, @Nullable Duration interval, @Nullable Predicate<Map<String, String>> dedupePredicate, @Nullable Map<String, String> labels) {
        String eventName = EventUtils.generateEventName(target, type, reason, messageKey != null ? messageKey : message, component);
        Event existing = EventUtils.findExistingEvent(client, target, eventName);
        if (existing != null) {
            if (EventUtils.labelCheck(existing, dedupePredicate) && EventUtils.intervalCheck(existing, interval)) {
                return false;
            }
            EventUtils.updatedEventWithLabels(existing, client, message, eventListener, labels);
            return false;
        }
        Event event = EventUtils.buildEvent(target, type, reason, message, component, eventName);
        EventUtils.setLabels(event, labels);
        EventUtils.createOrReplaceEvent(client, event).ifPresent(eventListener);
        return true;
    }

    private static void updatedEventWithLabels(Event existing, KubernetesClient client, String message, Consumer<Event> eventListener, @Nullable Map<String, String> labels) {
        existing.setLastTimestamp(Instant.now().toString());
        existing.setCount(Integer.valueOf(existing.getCount() + 1));
        existing.setMessage(message);
        EventUtils.setLabels(existing, labels);
        EventUtils.createOrReplaceEvent(client, existing).ifPresent(eventListener);
    }

    private static void setLabels(Event existing, @Nullable Map<String, String> labels) {
        if (labels == null) {
            return;
        }
        if (existing.getMetadata() == null) {
            existing.setMetadata(new ObjectMeta());
        }
        existing.getMetadata().setLabels(labels);
    }

    private static Event buildEvent(HasMetadata target, EventRecorder.Type type, String reason, String message, EventRecorder.Component component, String eventName) {
        return ((EventBuilder)((EventFluent.MetadataNested)((EventFluent.MetadataNested)((EventBuilder)((EventBuilder)((EventBuilder)((EventFluent.SourceNested)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)new EventBuilder().withApiVersion("v1")).withInvolvedObject(((ObjectReferenceBuilder)((ObjectReferenceBuilder)((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind(target.getKind())).withUid(target.getMetadata().getUid())).withName(target.getMetadata().getName())).withNamespace(target.getMetadata().getNamespace())).build())).withType(type.name())).withReason(reason)).withFirstTimestamp(Instant.now().toString())).withLastTimestamp(Instant.now().toString())).withNewSource().withComponent(component.name())).endSource()).withCount(Integer.valueOf(1))).withMessage(message)).withNewMetadata().withName(eventName)).withNamespace(target.getMetadata().getNamespace())).endMetadata()).build();
    }

    private static boolean intervalCheck(Event existing, @Nullable Duration interval) {
        return interval != null && Instant.now().isBefore(Instant.parse(existing.getLastTimestamp()).plusMillis(interval.toMillis()));
    }

    private static boolean labelCheck(Event existing, Predicate<Map<String, String>> dedupePredicate) {
        return dedupePredicate == null || existing.getMetadata() != null && dedupePredicate.test(existing.getMetadata().getLabels());
    }

    private static Optional<Event> createOrReplaceEvent(KubernetesClient client, Event event) {
        try {
            Event createdEvent = (Event)client.resource((HasMetadata)event).createOrReplace();
            return Optional.of(createdEvent);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 403) {
                throw e;
            }
            LOG.warn("Cannot create or update events, proceeding.", (Throwable)e);
            return Optional.empty();
        }
    }
}

