/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.informer.InformerEventSource;
import io.javaoperatorsdk.operator.processing.event.source.informer.Mappers;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.controller.FlinkDeploymentController;
import org.apache.flink.kubernetes.operator.controller.FlinkSessionJobController;

public class EventSourceUtils {
    private static final String FLINK_DEPLOYMENT_IDX = FlinkDeploymentController.class.getName();
    private static final String FLINK_SESSIONJOB_IDX = FlinkSessionJobController.class.getName();

    public static InformerEventSource<Deployment, FlinkDeployment> getDeploymentInformerEventSource(EventSourceContext<FlinkDeployment> context) {
        String labelSelector = Map.of("component", "jobmanager").entrySet().stream().map(Object::toString).collect(Collectors.joining(","));
        InformerConfiguration configuration = InformerConfiguration.from(Deployment.class, context).withLabelSelector(labelSelector).withSecondaryToPrimaryMapper(Mappers.fromLabel((String)"app")).withNamespacesInheritedFromController(context).followNamespaceChanges(true).build();
        return new InformerEventSource(configuration, context);
    }

    public static InformerEventSource<FlinkSessionJob, FlinkDeployment> getSessionJobInformerEventSource(EventSourceContext<FlinkDeployment> context) {
        context.getPrimaryCache().addIndexer(FLINK_DEPLOYMENT_IDX, flinkDeployment -> List.of(EventSourceUtils.indexKey(flinkDeployment.getMetadata().getName(), flinkDeployment.getMetadata().getNamespace())));
        InformerConfiguration configuration = InformerConfiguration.from(FlinkSessionJob.class, context).withSecondaryToPrimaryMapper(sessionJob -> context.getPrimaryCache().byIndex(FLINK_DEPLOYMENT_IDX, EventSourceUtils.indexKey(((FlinkSessionJobSpec)sessionJob.getSpec()).getDeploymentName(), sessionJob.getMetadata().getNamespace())).stream().map(ResourceID::fromResource).collect(Collectors.toSet())).withNamespacesInheritedFromController(context).followNamespaceChanges(true).build();
        return new InformerEventSource(configuration, context);
    }

    public static InformerEventSource<FlinkDeployment, FlinkSessionJob> getFlinkDeploymentInformerEventSource(EventSourceContext<FlinkSessionJob> context) {
        context.getPrimaryCache().addIndexer(FLINK_SESSIONJOB_IDX, sessionJob -> List.of(EventSourceUtils.indexKey(((FlinkSessionJobSpec)sessionJob.getSpec()).getDeploymentName(), sessionJob.getMetadata().getNamespace())));
        InformerConfiguration configuration = InformerConfiguration.from(FlinkDeployment.class, context).withSecondaryToPrimaryMapper(flinkDeployment -> context.getPrimaryCache().byIndex(FLINK_SESSIONJOB_IDX, EventSourceUtils.indexKey(flinkDeployment.getMetadata().getName(), flinkDeployment.getMetadata().getNamespace())).stream().map(ResourceID::fromResource).collect(Collectors.toSet())).withPrimaryToSecondaryMapper(sessionJob -> Set.of(new ResourceID(((FlinkSessionJobSpec)sessionJob.getSpec()).getDeploymentName(), sessionJob.getMetadata().getNamespace()))).withNamespacesInheritedFromController(context).followNamespaceChanges(true).build();
        return new InformerEventSource(configuration, context);
    }

    private static String indexKey(String name, String namespace) {
        return name + "#" + namespace;
    }
}

