/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.listener.FlinkResourceListener;
import org.apache.flink.kubernetes.operator.listener.AuditUtils;
import org.apache.flink.kubernetes.operator.utils.EventUtils;

public class EventRecorder {
    private final BiConsumer<AbstractFlinkResource<?, ?>, Event> eventListener;

    public EventRecorder(BiConsumer<AbstractFlinkResource<?, ?>, Event> eventListener) {
        this.eventListener = eventListener;
    }

    public boolean triggerEvent(AbstractFlinkResource<?, ?> resource, Type type, Reason reason, Component component, String message, KubernetesClient client) {
        return this.triggerEvent(resource, type, reason, message, component, null, client);
    }

    public boolean triggerEventOnce(AbstractFlinkResource<?, ?> resource, Type type, Reason reason, String message, Component component, String messageKey, KubernetesClient client) {
        return this.triggerEventOnce(resource, type, reason.toString(), message, component, messageKey, client);
    }

    public boolean triggerEvent(AbstractFlinkResource<?, ?> resource, Type type, Reason reason, String message, Component component, @Nullable String messageKey, KubernetesClient client) {
        return this.triggerEvent(resource, type, reason.toString(), message, component, messageKey, client);
    }

    public boolean triggerEvent(AbstractFlinkResource<?, ?> resource, Type type, String reason, String message, Component component, String messageKey, KubernetesClient client) {
        return EventUtils.createOrUpdateEventWithInterval(client, resource, type, reason, message, component, e -> this.eventListener.accept(resource, (Event)e), messageKey, null);
    }

    public boolean triggerEventWithInterval(AbstractFlinkResource<?, ?> resource, Type type, String reason, String message, Component component, String messageKey, KubernetesClient client, @Nullable Duration interval) {
        return EventUtils.createOrUpdateEventWithInterval(client, resource, type, reason, message, component, e -> this.eventListener.accept(resource, (Event)e), messageKey, interval);
    }

    public boolean triggerEventOnce(AbstractFlinkResource<?, ?> resource, Type type, String reason, String message, Component component, String messageKey, KubernetesClient client) {
        return EventUtils.createIfNotExists(client, resource, type, reason, message, component, e -> this.eventListener.accept(resource, (Event)e), messageKey);
    }

    public boolean triggerEventWithLabels(AbstractFlinkResource<?, ?> resource, Type type, String reason, String message, Component component, @Nullable String messageKey, KubernetesClient client, @Nullable Duration interval, @Nullable Predicate<Map<String, String>> dedupePredicate, @Nullable Map<String, String> labels) {
        return EventUtils.createOrUpdateEventWithLabels(client, resource, type, reason, message, component, e -> this.eventListener.accept(resource, (Event)e), messageKey, interval, dedupePredicate, labels);
    }

    public boolean triggerEvent(AbstractFlinkResource<?, ?> resource, Type type, String reason, String message, Component component, KubernetesClient client) {
        return this.triggerEvent(resource, type, reason, message, component, null, client);
    }

    public static EventRecorder create(KubernetesClient client, Collection<FlinkResourceListener> listeners) {
        BiConsumer<AbstractFlinkResource<?, ?>, Event> biConsumer = (resource, event) -> {
            FlinkResourceListener.ResourceEventContext ctx = new FlinkResourceListener.ResourceEventContext(){
                final /* synthetic */ Event val$event;
                final /* synthetic */ AbstractFlinkResource val$resource;
                final /* synthetic */ KubernetesClient val$client;
                {
                    this.val$event = event;
                    this.val$resource = abstractFlinkResource;
                    this.val$client = kubernetesClient;
                }

                public Event getEvent() {
                    return this.val$event;
                }

                public AbstractFlinkResource<?, ?> getFlinkResource() {
                    return this.val$resource;
                }

                public KubernetesClient getKubernetesClient() {
                    return this.val$client;
                }
            };
            listeners.forEach(arg_0 -> EventRecorder.lambda$create$4(resource, ctx, arg_0));
            AuditUtils.logContext(ctx);
        };
        return new EventRecorder(biConsumer);
    }

    private static /* synthetic */ void lambda$create$4(AbstractFlinkResource resource, 1 ctx, FlinkResourceListener listener) {
        if (resource instanceof FlinkDeployment) {
            listener.onDeploymentEvent((FlinkResourceListener.ResourceEventContext)ctx);
        } else {
            listener.onSessionJobEvent((FlinkResourceListener.ResourceEventContext)ctx);
        }
    }

    public static enum Type {
        Normal,
        Warning;

    }

    public static enum Reason {
        Suspended,
        SpecChanged,
        Rollback,
        Submit,
        JobStatusChanged,
        SavepointError,
        CheckpointError,
        Cleanup,
        CleanupFailed,
        Missing,
        ValidationError,
        RecoverDeployment,
        RestartUnhealthyJob,
        ScalingReport,
        IneffectiveScaling,
        MemoryPressure,
        ResourceQuotaReached,
        AutoscalerError,
        Scaling,
        UnsupportedFlinkVersion;

    }

    public static enum Component {
        Operator,
        JobManagerDeployment,
        Job;

    }
}

