/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.service;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.api.spec.JobSpec;
import org.apache.flink.kubernetes.operator.api.spec.UpgradeMode;
import org.apache.flink.kubernetes.operator.api.status.CheckpointInfo;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.Savepoint;
import org.apache.flink.kubernetes.operator.api.status.SavepointInfo;
import org.apache.flink.kubernetes.operator.api.status.SnapshotTriggerType;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.observer.CheckpointFetchResult;
import org.apache.flink.kubernetes.operator.observer.SavepointFetchResult;
import org.apache.flink.kubernetes.operator.service.CheckpointHistoryWrapper;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.jobmaster.JobResult;

public interface FlinkService {
    public KubernetesClient getKubernetesClient();

    public void submitApplicationCluster(JobSpec var1, Configuration var2, boolean var3) throws Exception;

    public boolean isHaMetadataAvailable(Configuration var1);

    public void submitSessionCluster(Configuration var1) throws Exception;

    public JobID submitJobToSessionCluster(ObjectMeta var1, FlinkSessionJobSpec var2, JobID var3, Configuration var4, @Nullable String var5) throws Exception;

    public boolean isJobManagerPortReady(Configuration var1);

    public Collection<JobStatusMessage> listJobs(Configuration var1) throws Exception;

    public JobResult requestJobResult(Configuration var1, JobID var2) throws Exception;

    public void cancelJob(FlinkDeployment var1, UpgradeMode var2, Configuration var3) throws Exception;

    public void deleteClusterDeployment(ObjectMeta var1, FlinkDeploymentStatus var2, Configuration var3, boolean var4);

    public void cancelSessionJob(FlinkSessionJob var1, UpgradeMode var2, Configuration var3) throws Exception;

    public void triggerSavepoint(String var1, SnapshotTriggerType var2, SavepointInfo var3, Configuration var4) throws Exception;

    public void triggerCheckpoint(String var1, SnapshotTriggerType var2, CheckpointInfo var3, Configuration var4) throws Exception;

    public Optional<Savepoint> getLastCheckpoint(JobID var1, Configuration var2) throws Exception;

    public SavepointFetchResult fetchSavepointInfo(String var1, String var2, Configuration var3);

    public CheckpointFetchResult fetchCheckpointInfo(String var1, String var2, Configuration var3);

    public Tuple2<Optional<CheckpointHistoryWrapper.CompletedCheckpointInfo>, Optional<CheckpointHistoryWrapper.PendingCheckpointInfo>> getCheckpointInfo(JobID var1, Configuration var2) throws Exception;

    public void disposeSavepoint(String var1, Configuration var2) throws Exception;

    public Map<String, String> getClusterInfo(Configuration var1) throws Exception;

    public PodList getJmPodList(FlinkDeployment var1, Configuration var2);

    public boolean scale(FlinkResourceContext<?> var1, Configuration var2) throws Exception;

    public Map<String, String> getMetrics(Configuration var1, String var2, List<String> var3) throws Exception;

    public RestClusterClient<String> getClusterClient(Configuration var1) throws Exception;
}

