/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.resources;

public class KubernetesResource {
    private final double allocatable;
    private final double used;
    private double reserved;
    private double pending;

    public void commitPending() {
        this.reserved += this.pending;
        this.pending = 0.0;
    }

    public void release(double amount) {
        this.pending -= Math.min(amount, this.getUsed());
    }

    public double getFree() {
        return this.allocatable - this.getUsed();
    }

    public double getUsed() {
        return this.used + this.reserved + this.pending;
    }

    public String toString() {
        return "KubernetesResource{allocatable=" + this.allocatable + ", used=" + this.used + ", reserved=" + this.reserved + ", pending=" + this.pending + "}";
    }

    public KubernetesResource(double allocatable, double used) {
        this.allocatable = allocatable;
        this.used = used;
    }

    public double getAllocatable() {
        return this.allocatable;
    }

    public double getReserved() {
        return this.reserved;
    }

    public double getPending() {
        return this.pending;
    }

    public void setPending(double pending) {
        this.pending = pending;
    }
}

