/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer;

import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.spec.AbstractFlinkSpec;
import org.apache.flink.kubernetes.operator.api.status.Checkpoint;
import org.apache.flink.kubernetes.operator.api.status.CheckpointInfo;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.JobStatus;
import org.apache.flink.kubernetes.operator.api.status.Savepoint;
import org.apache.flink.kubernetes.operator.api.status.SavepointInfo;
import org.apache.flink.kubernetes.operator.api.status.SnapshotInfo;
import org.apache.flink.kubernetes.operator.api.status.SnapshotTriggerType;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.exception.ReconciliationException;
import org.apache.flink.kubernetes.operator.observer.CheckpointFetchResult;
import org.apache.flink.kubernetes.operator.observer.SavepointFetchResult;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.operator.reconciler.SnapshotType;
import org.apache.flink.kubernetes.operator.service.FlinkService;
import org.apache.flink.kubernetes.operator.utils.ConfigOptionUtils;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.SnapshotUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotObserver<CR extends AbstractFlinkResource<?, STATUS>, STATUS extends CommonStatus<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotObserver.class);
    private final EventRecorder eventRecorder;

    public SnapshotObserver(EventRecorder eventRecorder) {
        this.eventRecorder = eventRecorder;
    }

    public void observeSavepointStatus(FlinkResourceContext<CR> ctx) {
        CR resource = ctx.getResource();
        JobStatus jobStatus = ((CommonStatus)resource.getStatus()).getJobStatus();
        SavepointInfo savepointInfo = jobStatus.getSavepointInfo();
        String jobId = jobStatus.getJobId();
        if (SnapshotUtils.savepointInProgress(jobStatus)) {
            this.observeTriggeredSavepoint(ctx, jobId);
        }
        if (ReconciliationUtils.isJobInTerminalState((CommonStatus)resource.getStatus())) {
            this.observeLatestSavepoint(ctx.getFlinkService(), savepointInfo, jobId, ctx.getObserveConfig());
        }
        this.cleanupSavepointHistory(ctx, savepointInfo);
    }

    public void observeCheckpointStatus(FlinkResourceContext<CR> ctx) {
        if (!SnapshotUtils.isSnapshotTriggeringSupported(ctx.getObserveConfig())) {
            return;
        }
        CR resource = ctx.getResource();
        JobStatus jobStatus = ((CommonStatus)resource.getStatus()).getJobStatus();
        String jobId = jobStatus.getJobId();
        if (SnapshotUtils.checkpointInProgress(jobStatus)) {
            this.observeTriggeredCheckpoint(ctx, jobId);
        }
    }

    private void observeTriggeredSavepoint(FlinkResourceContext<CR> ctx, String jobID) {
        CR resource = ctx.getResource();
        SavepointInfo savepointInfo = ((CommonStatus)resource.getStatus()).getJobStatus().getSavepointInfo();
        LOG.info("Observing savepoint status.");
        SavepointFetchResult savepointFetchResult = ctx.getFlinkService().fetchSavepointInfo(savepointInfo.getTriggerId(), jobID, ctx.getObserveConfig());
        if (savepointFetchResult.isPending()) {
            LOG.info("Savepoint operation not finished yet...");
            return;
        }
        if (savepointFetchResult.getError() != null) {
            String err = savepointFetchResult.getError();
            Duration gracePeriod = (Duration)ctx.getObserveConfig().get(KubernetesOperatorConfigOptions.OPERATOR_SAVEPOINT_TRIGGER_GRACE_PERIOD);
            if (SnapshotUtils.gracePeriodEnded(gracePeriod, (SnapshotInfo)savepointInfo)) {
                LOG.error("Savepoint attempt failed after grace period. Won't be retried again: " + err);
                ReconciliationUtils.updateLastReconciledSnapshotTriggerNonce((SnapshotInfo)savepointInfo, resource, SnapshotType.SAVEPOINT);
            } else {
                LOG.warn("Savepoint failed within grace period, retrying: " + err);
            }
            this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)resource, EventRecorder.Type.Warning, EventRecorder.Reason.SavepointError, EventRecorder.Component.Operator, savepointInfo.formatErrorMessage(((AbstractFlinkSpec)resource.getSpec()).getJob().getSavepointTriggerNonce()), ctx.getKubernetesClient());
            savepointInfo.resetTrigger();
            return;
        }
        Savepoint savepoint = new Savepoint(savepointInfo.getTriggerTimestamp().longValue(), savepointFetchResult.getLocation(), savepointInfo.getTriggerType(), savepointInfo.getFormatType(), SnapshotTriggerType.MANUAL == savepointInfo.getTriggerType() ? ((AbstractFlinkSpec)resource.getSpec()).getJob().getSavepointTriggerNonce() : null);
        ReconciliationUtils.updateLastReconciledSnapshotTriggerNonce((SnapshotInfo)savepointInfo, resource, SnapshotType.SAVEPOINT);
        savepointInfo.updateLastSavepoint(savepoint);
    }

    private void observeTriggeredCheckpoint(FlinkResourceContext<CR> ctx, String jobID) {
        CR resource = ctx.getResource();
        CheckpointInfo checkpointInfo = ((CommonStatus)resource.getStatus()).getJobStatus().getCheckpointInfo();
        LOG.info("Observing checkpoint status.");
        CheckpointFetchResult checkpointFetchResult = ctx.getFlinkService().fetchCheckpointInfo(checkpointInfo.getTriggerId(), jobID, ctx.getObserveConfig());
        if (checkpointFetchResult.isPending()) {
            LOG.info("Checkpoint operation not finished yet...");
            return;
        }
        if (checkpointFetchResult.getError() != null) {
            String err = checkpointFetchResult.getError();
            Duration gracePeriod = (Duration)ctx.getObserveConfig().get(KubernetesOperatorConfigOptions.OPERATOR_CHECKPOINT_TRIGGER_GRACE_PERIOD);
            if (SnapshotUtils.gracePeriodEnded(gracePeriod, (SnapshotInfo)checkpointInfo)) {
                LOG.error("Checkpoint attempt failed after grace period. Won't be retried again: " + err);
                ReconciliationUtils.updateLastReconciledSnapshotTriggerNonce((SnapshotInfo)checkpointInfo, resource, SnapshotType.CHECKPOINT);
            } else {
                LOG.warn("Checkpoint failed within grace period, retrying: " + err);
            }
            this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)resource, EventRecorder.Type.Warning, EventRecorder.Reason.CheckpointError, EventRecorder.Component.Operator, checkpointInfo.formatErrorMessage(((AbstractFlinkSpec)resource.getSpec()).getJob().getCheckpointTriggerNonce()), ctx.getKubernetesClient());
            checkpointInfo.resetTrigger();
            return;
        }
        Checkpoint checkpoint = new Checkpoint(checkpointInfo.getTriggerTimestamp().longValue(), checkpointInfo.getTriggerType(), checkpointInfo.getFormatType(), SnapshotTriggerType.MANUAL == checkpointInfo.getTriggerType() ? ((AbstractFlinkSpec)resource.getSpec()).getJob().getCheckpointTriggerNonce() : null);
        ReconciliationUtils.updateLastReconciledSnapshotTriggerNonce((SnapshotInfo)checkpointInfo, resource, SnapshotType.CHECKPOINT);
        checkpointInfo.updateLastCheckpoint(checkpoint);
    }

    @VisibleForTesting
    void cleanupSavepointHistory(FlinkResourceContext<CR> ctx, SavepointInfo currentSavepointInfo) {
        Configuration observeConfig = ctx.getObserveConfig();
        FlinkService flinkService = ctx.getFlinkService();
        boolean savepointCleanupEnabled = observeConfig.getBoolean(KubernetesOperatorConfigOptions.OPERATOR_SAVEPOINT_CLEANUP_ENABLED);
        List savepointHistory = currentSavepointInfo.getSavepointHistory();
        if (savepointHistory.size() < 2) {
            return;
        }
        Savepoint lastSavepoint = (Savepoint)savepointHistory.get(savepointHistory.size() - 1);
        int maxCount = Math.max(1, ConfigOptionUtils.getValueWithThreshold(observeConfig, KubernetesOperatorConfigOptions.OPERATOR_SAVEPOINT_HISTORY_MAX_COUNT, ctx.getOperatorConfig().getSavepointHistoryCountThreshold()));
        while (savepointHistory.size() > maxCount) {
            Savepoint sp = (Savepoint)savepointHistory.remove(0);
            if (!savepointCleanupEnabled) continue;
            this.disposeSavepointQuietly(flinkService, sp, observeConfig);
        }
        Duration maxAge = ConfigOptionUtils.getValueWithThreshold(observeConfig, KubernetesOperatorConfigOptions.OPERATOR_SAVEPOINT_HISTORY_MAX_AGE, ctx.getOperatorConfig().getSavepointHistoryAgeThreshold());
        long maxTms = System.currentTimeMillis() - maxAge.toMillis();
        Iterator it = savepointHistory.iterator();
        while (it.hasNext()) {
            Savepoint sp = (Savepoint)it.next();
            if (sp.getTimeStamp() >= maxTms || sp == lastSavepoint) continue;
            it.remove();
            if (!savepointCleanupEnabled) continue;
            this.disposeSavepointQuietly(flinkService, sp, observeConfig);
        }
    }

    private void disposeSavepointQuietly(FlinkService flinkService, Savepoint sp, Configuration conf) {
        try {
            LOG.info("Disposing savepoint {}", (Object)sp);
            flinkService.disposeSavepoint(sp.getLocation(), conf);
        }
        catch (Exception e) {
            LOG.error("Exception while disposing savepoint {}", (Object)sp.getLocation(), (Object)e);
        }
    }

    private void observeLatestSavepoint(FlinkService flinkService, SavepointInfo savepointInfo, String jobID, Configuration observeConfig) {
        try {
            flinkService.getLastCheckpoint(JobID.fromHexString((String)jobID), observeConfig).ifPresent(arg_0 -> ((SavepointInfo)savepointInfo).updateLastSavepoint(arg_0));
        }
        catch (Exception e) {
            LOG.error("Could not observe latest savepoint information.", (Throwable)e);
            throw new ReconciliationException(e);
        }
    }
}

