/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer;

import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationState;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationStatus;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.observer.Observer;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.SnapshotUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlinkResourceObserver<CR extends AbstractFlinkResource<?, ?>>
implements Observer<CR> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final EventRecorder eventRecorder;

    public AbstractFlinkResourceObserver(EventRecorder eventRecorder) {
        this.eventRecorder = eventRecorder;
    }

    @Override
    public final void observe(FlinkResourceContext<CR> ctx) {
        if (!this.isResourceReadyToBeObserved(ctx)) {
            return;
        }
        this.observeInternal(ctx);
        SnapshotUtils.resetSnapshotTriggers(ctx.getResource(), this.eventRecorder, ctx.getKubernetesClient());
    }

    protected boolean isResourceReadyToBeObserved(FlinkResourceContext<CR> ctx) {
        CR resource = ctx.getResource();
        ReconciliationStatus reconciliationStatus = ((CommonStatus)resource.getStatus()).getReconciliationStatus();
        if (reconciliationStatus.isBeforeFirstDeployment()) {
            this.logger.debug("Skipping observe before first deployment");
            return false;
        }
        if (reconciliationStatus.getState() == ReconciliationState.ROLLING_BACK) {
            this.logger.debug("Skipping observe during rollback operation");
            return false;
        }
        if (reconciliationStatus.getState() == ReconciliationState.UPGRADING) {
            if (reconciliationStatus.scalingInProgress()) {
                reconciliationStatus.setState(ReconciliationState.DEPLOYED);
            } else if (this.checkIfAlreadyUpgraded(ctx)) {
                ReconciliationUtils.updateStatusForAlreadyUpgraded(resource);
            } else {
                ReconciliationUtils.clearLastReconciledSpecIfFirstDeploy(resource);
                this.logger.debug("Skipping observe before resource is deployed during upgrade");
                return false;
            }
        }
        return true;
    }

    protected abstract void observeInternal(FlinkResourceContext<CR> var1);

    protected abstract boolean checkIfAlreadyUpgraded(FlinkResourceContext<CR> var1);
}

