/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.metrics.CustomResourceMetrics;
import org.apache.flink.kubernetes.operator.metrics.FlinkDeploymentMetrics;
import org.apache.flink.kubernetes.operator.metrics.FlinkSessionJobMetrics;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricGroup;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricOptions;
import org.apache.flink.kubernetes.operator.metrics.lifecycle.LifecycleMetrics;

public class MetricManager<CR extends AbstractFlinkResource<?, ?>> {
    private final List<CustomResourceMetrics<CR>> registeredMetrics = new ArrayList<CustomResourceMetrics<CR>>();

    public void onUpdate(CR cr) {
        this.registeredMetrics.forEach(m -> m.onUpdate(cr));
    }

    public void onRemove(CR cr) {
        this.registeredMetrics.forEach(m -> m.onRemove(cr));
    }

    public void register(CustomResourceMetrics<CR> metrics) {
        this.registeredMetrics.add(metrics);
    }

    public static MetricManager<FlinkDeployment> createFlinkDeploymentMetricManager(Configuration conf, KubernetesOperatorMetricGroup metricGroup) {
        MetricManager<FlinkDeployment> metricManager = new MetricManager<FlinkDeployment>();
        MetricManager.registerFlinkDeploymentMetrics(conf, metricGroup, metricManager);
        MetricManager.registerLifecycleMetrics(conf, metricGroup, metricManager);
        return metricManager;
    }

    public static MetricManager<FlinkSessionJob> createFlinkSessionJobMetricManager(Configuration conf, KubernetesOperatorMetricGroup metricGroup) {
        MetricManager<FlinkSessionJob> metricManager = new MetricManager<FlinkSessionJob>();
        MetricManager.registerFlinkSessionJobMetrics(conf, metricGroup, metricManager);
        MetricManager.registerLifecycleMetrics(conf, metricGroup, metricManager);
        return metricManager;
    }

    private static void registerFlinkDeploymentMetrics(Configuration conf, KubernetesOperatorMetricGroup metricGroup, MetricManager<FlinkDeployment> metricManager) {
        if (((Boolean)conf.get(KubernetesOperatorMetricOptions.OPERATOR_RESOURCE_METRICS_ENABLED)).booleanValue()) {
            metricManager.register(new FlinkDeploymentMetrics(metricGroup, conf));
        }
    }

    private static void registerFlinkSessionJobMetrics(Configuration conf, KubernetesOperatorMetricGroup metricGroup, MetricManager<FlinkSessionJob> metricManager) {
        if (((Boolean)conf.get(KubernetesOperatorMetricOptions.OPERATOR_RESOURCE_METRICS_ENABLED)).booleanValue()) {
            metricManager.register(new FlinkSessionJobMetrics(metricGroup, conf));
        }
    }

    private static <CR extends AbstractFlinkResource<?, ?>> void registerLifecycleMetrics(Configuration conf, KubernetesOperatorMetricGroup metricGroup, MetricManager<CR> metricManager) {
        if (((Boolean)conf.get(KubernetesOperatorMetricOptions.OPERATOR_RESOURCE_METRICS_ENABLED)).booleanValue() && ((Boolean)conf.get(KubernetesOperatorMetricOptions.OPERATOR_LIFECYCLE_METRICS_ENABLED)).booleanValue()) {
            metricManager.register(new LifecycleMetrics(conf, metricGroup));
        }
    }

    @VisibleForTesting
    public List<CustomResourceMetrics<CR>> getRegisteredMetrics() {
        return this.registeredMetrics;
    }
}

