/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.listener;

import io.fabric8.kubernetes.api.model.Event;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.lifecycle.ResourceLifecycleState;
import org.apache.flink.kubernetes.operator.api.listener.FlinkResourceListener;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuditUtils.class);

    public static <R extends AbstractFlinkResource<?, S>, S extends CommonStatus<?>> void logContext(FlinkResourceListener.StatusUpdateContext<R, S> ctx) {
        LOG.info(AuditUtils.format(ctx.getNewStatus()));
    }

    public static <R extends AbstractFlinkResource<?, ?>> void logContext(FlinkResourceListener.ResourceEventContext<R> ctx) {
        LOG.info(AuditUtils.format(ctx.getEvent()));
    }

    private static String format(@NonNull CommonStatus<?> status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        ResourceLifecycleState lifeCycleState = status.getLifecycleState();
        return String.format(">>> Status | %-7s | %-15s | %s ", StringUtils.isEmpty((CharSequence)status.getError()) ? "Info" : "Error", lifeCycleState, StringUtils.isEmpty((CharSequence)status.getError()) ? lifeCycleState.getDescription() : status.getError());
    }

    @VisibleForTesting
    public static String format(@NonNull Event event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return String.format(">>> Event  | %-7s | %-15s | %s", event.getType().equals("Normal") ? "Info" : event.getType(), event.getReason().toUpperCase(), event.getMessage());
    }
}

