/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.health;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.flink.kubernetes.operator.health.HealthProbe;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpObject;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.util.ExceptionUtils;

@ChannelHandler.Sharable
public class OperatorHealthHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final HealthProbe probe = HealthProbe.INSTANCE;

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        block4: {
            try {
                if (this.probe.isHealthy()) {
                    ctx.writeAndFlush((Object)this.createResponse("OK", HttpResponseStatus.OK));
                } else {
                    ctx.writeAndFlush((Object)this.createResponse("ERROR", HttpResponseStatus.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable t) {
                if (!ctx.channel().isActive()) break block4;
                ctx.writeAndFlush((Object)this.createResponse(ExceptionUtils.stringifyException((Throwable)t), HttpResponseStatus.INTERNAL_SERVER_ERROR));
            }
        }
    }

    private DefaultFullHttpResponse createResponse(String content, HttpResponseStatus status) {
        ByteBuf buff = Unpooled.copiedBuffer((CharSequence)content, (Charset)StandardCharsets.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, buff);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain;charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)buff.readableBytes());
        return response;
    }
}

