/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.health;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.spec.AbstractFlinkSpec;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanaryResourceManager<CR extends AbstractFlinkResource<?, ?>> {
    private static final Logger LOG = LoggerFactory.getLogger(CanaryResourceManager.class);
    public static final String CANARY_LABEL = "flink.apache.org/canary";
    private final ConcurrentHashMap<ResourceID, CanaryResourceState> canaryResources = new ConcurrentHashMap();
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(3);
    private final FlinkConfigManager configManager;

    public boolean allCanariesHealthy() {
        return this.canaryResources.values().stream().allMatch(cr -> cr.isHealthy);
    }

    public boolean handleCanaryResourceReconciliation(CR resource, KubernetesClient client) {
        if (!CanaryResourceManager.isCanaryResource(resource)) {
            return false;
        }
        ResourceID resourceId = ResourceID.fromResource(resource);
        LOG.info("Reconciling canary resource");
        this.canaryResources.compute(resourceId, (id, previousState) -> {
            boolean firstReconcile = false;
            if (previousState == null) {
                firstReconcile = true;
                previousState = new CanaryResourceState();
            }
            previousState.onReconcile(resource);
            if (firstReconcile) {
                this.updateSpecAndScheduleHealthCheck(resourceId, (CanaryResourceState)previousState, client);
            }
            return previousState;
        });
        return true;
    }

    public boolean handleCanaryResourceDeletion(CR resource) {
        if (!CanaryResourceManager.isCanaryResource(resource)) {
            return false;
        }
        ResourceID resourceId = ResourceID.fromResource(resource);
        LOG.info("Deleting canary resource");
        this.canaryResources.remove(resourceId);
        return true;
    }

    private void updateSpecAndScheduleHealthCheck(ResourceID resourceID, CanaryResourceState crs, KubernetesClient client) {
        Duration canaryTimeout = (Duration)this.configManager.getDefaultConfig().get(KubernetesOperatorConfigOptions.CANARY_RESOURCE_TIMEOUT);
        Long restartNonce = ((AbstractFlinkSpec)crs.resource.getSpec()).getRestartNonce();
        ((AbstractFlinkSpec)crs.resource.getSpec()).setRestartNonce(Long.valueOf(restartNonce == null ? 1L : restartNonce + 1L));
        crs.previousGeneration = crs.resource.getMetadata().getGeneration();
        LOG.info("Scheduling canary check for {} in {}s", (Object)resourceID, (Object)canaryTimeout.toSeconds());
        try {
            client.resource((HasMetadata)((AbstractFlinkResource)ReconciliationUtils.clone(crs.resource))).replace();
        }
        catch (Throwable t) {
            LOG.warn("Could not bump canary deployment, it may have been deleted", t);
        }
        this.executorService.schedule(() -> this.checkHealth(resourceID, client), canaryTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    protected void checkHealth(ResourceID resourceID, KubernetesClient client) {
        CanaryResourceState crs = this.canaryResources.get(resourceID);
        if (crs == null) {
            LOG.info("Canary resource {} not found. Stopping health checks", (Object)resourceID);
            return;
        }
        if (crs.canaryReconciledSinceUpdate()) {
            LOG.info("Canary deployment healthy");
            crs.isHealthy = true;
        } else {
            LOG.error("Canary deployment {} latest spec not reconciled. Expected generation larger than {}, received {}", new Object[]{resourceID, crs.previousGeneration, crs.resource.getMetadata().getGeneration()});
            crs.isHealthy = false;
        }
        this.updateSpecAndScheduleHealthCheck(resourceID, crs, client);
    }

    @VisibleForTesting
    public int getNumberOfActiveCanaries() {
        return this.canaryResources.size();
    }

    public static boolean isCanaryResource(HasMetadata resource) {
        Map labels = resource.getMetadata().getLabels();
        if (labels == null) {
            return false;
        }
        return "true".equalsIgnoreCase(labels.getOrDefault(CANARY_LABEL, "false"));
    }

    public CanaryResourceManager(FlinkConfigManager configManager) {
        this.configManager = configManager;
    }

    private class CanaryResourceState {
        CR resource;
        long previousGeneration;
        boolean isHealthy = true;

        private CanaryResourceState() {
        }

        void onReconcile(CR cr) {
            this.resource = cr;
        }

        boolean canaryReconciledSinceUpdate() {
            return this.resource.getMetadata().getGeneration() > this.previousGeneration;
        }
    }
}

