/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.controller;

import io.javaoperatorsdk.operator.api.reconciler.Context;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.spec.AbstractFlinkSpec;
import org.apache.flink.kubernetes.operator.api.spec.FlinkDeploymentSpec;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.api.spec.FlinkVersion;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceMetricGroup;
import org.apache.flink.kubernetes.operator.reconciler.sessionjob.SessionJobReconciler;
import org.apache.flink.kubernetes.operator.service.FlinkService;

public class FlinkSessionJobContext
extends FlinkResourceContext<FlinkSessionJob> {
    private FlinkVersion flinkVersion;

    public FlinkSessionJobContext(FlinkSessionJob resource, Context<?> josdkContext, KubernetesResourceMetricGroup resourceMetricGroup, FlinkConfigManager configManager, Function<FlinkResourceContext<?>, FlinkService> flinkServiceFactory) {
        super(resource, josdkContext, resourceMetricGroup, configManager, flinkServiceFactory);
    }

    @Override
    public Configuration getDeployConfig(AbstractFlinkSpec spec) {
        Optional session = this.getJosdkContext().getSecondaryResource(FlinkDeployment.class);
        if (SessionJobReconciler.sessionClusterReady(session)) {
            return this.configManager.getSessionJobConfig((FlinkDeployment)session.get(), (FlinkSessionJobSpec)spec);
        }
        return null;
    }

    @Override
    protected FlinkService createFlinkService() {
        Optional session = this.getJosdkContext().getSecondaryResource(FlinkDeployment.class);
        return SessionJobReconciler.sessionClusterReady(session) ? super.createFlinkService() : null;
    }

    @Override
    protected Configuration createObserveConfig() {
        return this.getDeployConfig((AbstractFlinkSpec)((FlinkSessionJob)this.getResource()).getSpec());
    }

    @Override
    public KubernetesDeploymentMode getDeploymentMode() {
        return KubernetesDeploymentMode.getDeploymentMode((FlinkDeployment)((FlinkDeployment)this.getJosdkContext().getSecondaryResource(FlinkDeployment.class).get()));
    }

    @Override
    public FlinkVersion getFlinkVersion() {
        if (this.flinkVersion != null) {
            return this.flinkVersion;
        }
        this.flinkVersion = this.getJosdkContext().getSecondaryResource(FlinkDeployment.class).map(fd -> ((FlinkDeploymentSpec)fd.getSpec()).getFlinkVersion()).orElse(null);
        return this.flinkVersion;
    }
}

