/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.config;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.kubernetes.operator.api.status.CheckpointType;

public class KubernetesOperatorConfigOptions {
    public static final String K8S_OP_CONF_PREFIX = "kubernetes.operator.";
    private static final String DEFAULT_CONF_PREFIX = "kubernetes.operator.default-configuration.";
    public static final String VERSION_CONF_PREFIX = "kubernetes.operator.default-configuration.flink-version.";
    public static final String NAMESPACE_CONF_PREFIX = "kubernetes.operator.default-configuration.namespace.";
    public static final String SECTION_SYSTEM = "system";
    public static final String SECTION_ADVANCED = "system_advanced";
    public static final String SECTION_DYNAMIC = "dynamic";
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Duration> OPERATOR_RECONCILE_INTERVAL = KubernetesOperatorConfigOptions.operatorConfig("reconcile.interval").durationType().defaultValue((Object)Duration.ofSeconds(60L)).withDeprecatedKeys(new String[]{"kubernetes.operator.reconciler.reschedule.interval"}).withDescription("The interval for the controller to reschedule the reconcile process.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Duration> OPERATOR_OBSERVER_REST_READY_DELAY = KubernetesOperatorConfigOptions.operatorConfig("observer.rest-ready.delay").durationType().defaultValue((Object)Duration.ofSeconds(10L)).withDescription("Final delay before deployment is marked ready after port becomes accessible.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Integer> OPERATOR_RECONCILE_PARALLELISM = KubernetesOperatorConfigOptions.operatorConfig("reconcile.parallelism").intType().defaultValue((Object)50).withDeprecatedKeys(new String[]{KubernetesOperatorConfigOptions.operatorConfigKey("reconciler.max.parallelism")}).withDescription("The maximum number of threads running the reconciliation loop. Use -1 for infinite.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Duration> OPERATOR_OBSERVER_PROGRESS_CHECK_INTERVAL = KubernetesOperatorConfigOptions.operatorConfig("observer.progress-check.interval").durationType().defaultValue((Object)Duration.ofSeconds(10L)).withDescription("The interval for observing status for in-progress operations such as deployment and savepoints.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Duration> OPERATOR_SAVEPOINT_TRIGGER_GRACE_PERIOD = KubernetesOperatorConfigOptions.operatorConfig("savepoint.trigger.grace-period").durationType().defaultValue((Object)Duration.ofMinutes(1L)).withDeprecatedKeys(new String[]{KubernetesOperatorConfigOptions.operatorConfigKey("observer.savepoint.trigger.grace-period")}).withDescription("The interval before a savepoint trigger attempt is marked as unsuccessful.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Duration> OPERATOR_CHECKPOINT_TRIGGER_GRACE_PERIOD = KubernetesOperatorConfigOptions.operatorConfig("checkpoint.trigger.grace-period").durationType().defaultValue((Object)Duration.ofMinutes(1L)).withDescription("The interval before a checkpoint trigger attempt is marked as unsuccessful.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Duration> OPERATOR_FLINK_CLIENT_TIMEOUT = KubernetesOperatorConfigOptions.operatorConfig("flink.client.timeout").durationType().defaultValue((Object)Duration.ofSeconds(10L)).withDeprecatedKeys(new String[]{KubernetesOperatorConfigOptions.operatorConfigKey("observer.flink.client.timeout")}).withDescription("The timeout for the observer to wait the flink rest client to return.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Duration> OPERATOR_FLINK_CLIENT_CANCEL_TIMEOUT = KubernetesOperatorConfigOptions.operatorConfig("flink.client.cancel.timeout").durationType().defaultValue((Object)Duration.ofMinutes(1L)).withDeprecatedKeys(new String[]{KubernetesOperatorConfigOptions.operatorConfigKey("reconciler.flink.cancel.job.timeout")}).withDescription("The timeout for the reconciler to wait for flink to cancel job.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Duration> OPERATOR_RESOURCE_CLEANUP_TIMEOUT = KubernetesOperatorConfigOptions.operatorConfig("resource.cleanup.timeout").durationType().defaultValue((Object)Duration.ofMinutes(5L)).withDeprecatedKeys(new String[]{KubernetesOperatorConfigOptions.operatorConfigKey("reconciler.flink.cluster.shutdown.timeout")}).withDescription("The timeout for the resource clean up to wait for flink to shutdown cluster.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> DEPLOYMENT_ROLLBACK_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("deployment.rollback.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to enable rolling back failed deployment upgrades.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Duration> DEPLOYMENT_READINESS_TIMEOUT = KubernetesOperatorConfigOptions.operatorConfig("deployment.readiness.timeout").durationType().defaultValue((Object)Duration.ofMinutes(5L)).withDescription("The timeout for deployments to become ready/stable before being rolled back if rollback is enabled.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<String> OPERATOR_USER_ARTIFACTS_BASE_DIR = KubernetesOperatorConfigOptions.operatorConfig("user.artifacts.base.dir").stringType().defaultValue((Object)"/opt/flink/artifacts").withDescription("The base dir to put the session job artifacts.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> JOB_UPGRADE_IGNORE_PENDING_SAVEPOINT = KubernetesOperatorConfigOptions.operatorConfig("job.upgrade.ignore-pending-savepoint").booleanType().defaultValue((Object)false).withDescription("Whether to ignore pending savepoint during job upgrade.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> JOB_UPGRADE_INPLACE_SCALING_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("job.upgrade.inplace-scaling.enabled").booleanType().defaultValue((Object)true).withDescription("Whether to enable inplace scaling for Flink 1.18+ using the resource requirements API. On failure or earlier Flink versions it falls back to regular full redeployment.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Boolean> OPERATOR_DYNAMIC_CONFIG_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("dynamic.config.enabled").booleanType().defaultValue((Object)true).withDescription("Whether to enable on-the-fly config changes through the operator configmap.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Duration> OPERATOR_DYNAMIC_CONFIG_CHECK_INTERVAL = KubernetesOperatorConfigOptions.operatorConfig("dynamic.config.check.interval").durationType().defaultValue((Object)Duration.ofMinutes(5L)).withDescription("Time interval for checking config changes.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Duration> OPERATOR_CONFIG_CACHE_TIMEOUT = KubernetesOperatorConfigOptions.operatorConfig("config.cache.timeout").durationType().defaultValue((Object)Duration.ofMinutes(10L)).withDescription("Expiration time for cached configs.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Integer> OPERATOR_CONFIG_CACHE_SIZE = KubernetesOperatorConfigOptions.operatorConfig("config.cache.size").intType().defaultValue((Object)1000).withDescription("Max config cache size.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> OPERATOR_JM_DEPLOYMENT_RECOVERY_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("jm-deployment-recovery.enabled").booleanType().defaultValue((Object)true).withDeprecatedKeys(new String[]{KubernetesOperatorConfigOptions.operatorConfigKey("reconciler.jm-deployment-recovery.enabled")}).withDescription("Whether to enable recovery of missing/deleted jobmanager deployments.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> OPERATOR_SAVEPOINT_CLEANUP_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("savepoint.cleanup.enabled").booleanType().defaultValue((Object)true).withDescription("Whether to enable clean up of savepoint history.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Integer> OPERATOR_SAVEPOINT_HISTORY_MAX_COUNT = KubernetesOperatorConfigOptions.operatorConfig("savepoint.history.max.count").intType().defaultValue((Object)10).withDescription("Maximum number of savepoint history entries to retain.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Integer> OPERATOR_SAVEPOINT_HISTORY_MAX_COUNT_THRESHOLD = ConfigOptions.key((String)(OPERATOR_SAVEPOINT_HISTORY_MAX_COUNT.key() + ".threshold")).intType().noDefaultValue().withDescription("Maximum number threshold of savepoint history entries to retain.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Duration> OPERATOR_SAVEPOINT_HISTORY_MAX_AGE = KubernetesOperatorConfigOptions.operatorConfig("savepoint.history.max.age").durationType().defaultValue((Object)Duration.ofHours(24L)).withDescription("Maximum age for savepoint history entries to retain. Due to lazy clean-up, the most recent savepoint may live longer than the max age.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Boolean> OPERATOR_EXCEPTION_STACK_TRACE_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("exception.stacktrace.enabled").booleanType().defaultValue((Object)false).withDescription("Enable exception stacktrace to be included in CR status error field.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Integer> OPERATOR_EXCEPTION_STACK_TRACE_MAX_LENGTH = KubernetesOperatorConfigOptions.operatorConfig("exception.stacktrace.max.length").intType().defaultValue((Object)2048).withDescription("Maximum length of stacktrace to be included in CR status error field.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Integer> OPERATOR_EXCEPTION_FIELD_MAX_LENGTH = KubernetesOperatorConfigOptions.operatorConfig("exception.field.max.length").intType().defaultValue((Object)2048).withDescription("Maximum length of each exception field including stack trace to be included in CR status error field.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Integer> OPERATOR_EXCEPTION_THROWABLE_LIST_MAX_COUNT = KubernetesOperatorConfigOptions.operatorConfig("exception.throwable.list.max.count").intType().defaultValue((Object)2).withDescription("Maximum number of throwable to be included in CR status error field.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Map<String, String>> OPERATOR_EXCEPTION_LABEL_MAPPER = KubernetesOperatorConfigOptions.operatorConfig("exception.label.mapper").mapType().defaultValue(new HashMap()).withDescription("Key-Value pair where key is the REGEX to filter through the exception messages and value is the string to be included in CR status error label field if the REGEX matches. Expected format: headerKey1:headerValue1,headerKey2:headerValue2.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Duration> OPERATOR_SAVEPOINT_HISTORY_MAX_AGE_THRESHOLD = ConfigOptions.key((String)(OPERATOR_SAVEPOINT_HISTORY_MAX_AGE.key() + ".threshold")).durationType().noDefaultValue().withDescription("Maximum age threshold for savepoint history entries to retain.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Map<String, String>> JAR_ARTIFACT_HTTP_HEADER = KubernetesOperatorConfigOptions.operatorConfig("user.artifacts.http.header").mapType().noDefaultValue().withDescription("Custom HTTP header for HttpArtifactFetcher. The header will be applied when getting the session job artifacts. Expected format: headerKey1:headerValue1,headerKey2:headerValue2.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<String> PERIODIC_SAVEPOINT_INTERVAL = KubernetesOperatorConfigOptions.operatorConfig("periodic.savepoint.interval").stringType().defaultValue((Object)"").withDescription("Option to enable automatic savepoint triggering. Can be specified either as a Duration type (i.e. '10m') or as a cron expression in Quartz format (6 or 7 positions, see http://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html).The triggering schedule is not guaranteed, savepoints will be triggered as part of the regular reconcile loop. WARNING: not intended to be used together with the cron-based periodic savepoint triggering");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<String> PERIODIC_CHECKPOINT_INTERVAL = KubernetesOperatorConfigOptions.operatorConfig("periodic.checkpoint.interval").stringType().defaultValue((Object)"").withDescription("Option to enable automatic checkpoint triggering. Can be specified either as a Duration type (i.e. '10m') or as a cron expression in Quartz format (6 or 7 positions, see http://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html).The triggering schedule is not guaranteed, checkpoints will be triggered as part of the regular reconcile loop. NOTE: checkpoints are generally managed by Flink. This setting isn't meant to replace Flink's checkpoint settings, but to complement them in special cases. For instance, a full checkpoint might need to be occasionally triggered to break the chain of incremental checkpoints and consolidate the partial incremental files. WARNING: not intended to be used together with the cron-based periodic checkpoint triggering");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<String> OPERATOR_WATCHED_NAMESPACES = KubernetesOperatorConfigOptions.operatorConfig("watched.namespaces").stringType().defaultValue((Object)"JOSDK_ALL_NAMESPACES").withDescription("Comma separated list of namespaces the operator monitors for custom resources.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<String> OPERATOR_LABEL_SELECTOR = KubernetesOperatorConfigOptions.operatorConfig("label.selector").stringType().noDefaultValue().withDescription("Label selector of the custom resources to be watched. Please see https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors for the format supported.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Boolean> OPERATOR_DYNAMIC_NAMESPACES_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("dynamic.namespaces.enabled").booleanType().defaultValue((Object)false).withDescription("Enables dynamic change of watched/monitored namespaces.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Duration> OPERATOR_RETRY_INITIAL_INTERVAL = KubernetesOperatorConfigOptions.operatorConfig("retry.initial.interval").durationType().defaultValue((Object)Duration.ofSeconds(5L)).withDescription("Initial interval of retries on unhandled controller errors.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Duration> OPERATOR_RETRY_MAX_INTERVAL = KubernetesOperatorConfigOptions.operatorConfig("retry.max.interval").durationType().noDefaultValue().withDescription("Max interval of retries on unhandled controller errors.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Double> OPERATOR_RETRY_INTERVAL_MULTIPLIER = KubernetesOperatorConfigOptions.operatorConfig("retry.interval.multiplier").doubleType().defaultValue((Object)1.5).withDescription("Interval multiplier of retries on unhandled controller errors.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Integer> OPERATOR_RETRY_MAX_ATTEMPTS = KubernetesOperatorConfigOptions.operatorConfig("retry.max.attempts").intType().defaultValue((Object)15).withDescription("Max attempts of retries on unhandled controller errors.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Duration> OPERATOR_RATE_LIMITER_PERIOD = KubernetesOperatorConfigOptions.operatorConfig("rate-limiter.refresh-period").durationType().defaultValue((Object)Duration.ofSeconds(15L)).withDescription("Operator rate limiter refresh period for each resource.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Integer> OPERATOR_RATE_LIMITER_LIMIT = KubernetesOperatorConfigOptions.operatorConfig("rate-limiter.limit").intType().defaultValue((Object)5).withDescription("Max number of reconcile loops triggered within the rate limiter refresh period for each resource. Setting the limit <= 0 disables the limiter.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> OPERATOR_JOB_UPGRADE_LAST_STATE_FALLBACK_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("job.upgrade.last-state-fallback.enabled").booleanType().defaultValue((Object)true).withDescription("Enables last-state fallback for savepoint upgrade mode. When the job is not running thus savepoint cannot be triggered but HA metadata is available for last state restore the operator can initiate the upgrade process when the flag is enabled.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Duration> OPERATOR_JOB_UPGRADE_LAST_STATE_CHECKPOINT_MAX_AGE = KubernetesOperatorConfigOptions.operatorConfig("job.upgrade.last-state.max.allowed.checkpoint.age").durationType().noDefaultValue().withDescription("Max allowed checkpoint age for initiating last-state upgrades on running jobs. If a checkpoint is not available within the desired age (and nothing in progress) a savepoint will be triggered.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<SavepointFormatType> OPERATOR_SAVEPOINT_FORMAT_TYPE = KubernetesOperatorConfigOptions.operatorConfig("savepoint.format.type").enumType(SavepointFormatType.class).defaultValue((Object)SavepointFormatType.DEFAULT).withDescription("Type of the binary format in which a savepoint should be taken.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<CheckpointType> OPERATOR_CHECKPOINT_TYPE = KubernetesOperatorConfigOptions.operatorConfig("checkpoint.type").enumType(CheckpointType.class).defaultValue((Object)CheckpointType.FULL).withDescription("Type of checkpoint.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Boolean> OPERATOR_HEALTH_PROBE_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("health.probe.enabled").booleanType().defaultValue((Object)true).withDescription("Enables health probe for the kubernetes operator.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Integer> OPERATOR_HEALTH_PROBE_PORT = KubernetesOperatorConfigOptions.operatorConfig("health.probe.port").intType().defaultValue((Object)8085).withDescription("The port the health probe will use to expose the status.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Boolean> OPERATOR_STOP_ON_INFORMER_ERROR = KubernetesOperatorConfigOptions.operatorConfig("startup.stop-on-informer-error").booleanType().defaultValue((Object)true).withDescription("Whether informer errors should stop operator startup. If false, the startup will ignore recoverable errors, caused for example by RBAC issues and will retry periodically.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Duration> OPERATOR_TERMINATION_TIMEOUT = KubernetesOperatorConfigOptions.operatorConfig("termination.timeout").durationType().defaultValue((Object)Duration.ofSeconds(10L)).withDescription("Operator shutdown timeout before reconciliation threads are killed.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> OPERATOR_CLUSTER_HEALTH_CHECK_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("cluster.health-check.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to enable health check for clusters.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Duration> OPERATOR_CLUSTER_HEALTH_CHECK_RESTARTS_WINDOW = KubernetesOperatorConfigOptions.operatorConfig("cluster.health-check.restarts.window").durationType().defaultValue((Object)Duration.ofMinutes(2L)).withDescription("The duration of the time window where job restart count measured.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Integer> OPERATOR_CLUSTER_HEALTH_CHECK_RESTARTS_THRESHOLD = KubernetesOperatorConfigOptions.operatorConfig("cluster.health-check.restarts.threshold").intType().defaultValue((Object)64).withDescription("The threshold which is checked against job restart count within a configured window. If the restart count is reaching the threshold then full cluster restart is initiated.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> OPERATOR_CLUSTER_HEALTH_CHECK_CHECKPOINT_PROGRESS_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("cluster.health-check.checkpoint-progress.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to enable checkpoint progress health check for clusters.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Duration> OPERATOR_CLUSTER_HEALTH_CHECK_CHECKPOINT_PROGRESS_WINDOW = KubernetesOperatorConfigOptions.operatorConfig("cluster.health-check.checkpoint-progress.window").durationType().defaultValue((Object)Duration.ofMinutes(5L)).withDescription("If no checkpoints are completed within the defined time window, the job is considered unhealthy. This must be bigger than checkpointing interval.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> OPERATOR_JOB_RESTART_FAILED = KubernetesOperatorConfigOptions.operatorConfig("job.restart.failed").booleanType().defaultValue((Object)false).withDescription("Whether to restart failed jobs.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Boolean> OPERATOR_LEADER_ELECTION_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("leader-election.enabled").booleanType().defaultValue((Object)false).withDescription("Enable leader election for the operator to allow running standby instances.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<String> OPERATOR_LEADER_ELECTION_LEASE_NAME = KubernetesOperatorConfigOptions.operatorConfig("leader-election.lease-name").stringType().noDefaultValue().withDescription("Leader election lease name, must be unique for leases in the same namespace.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Duration> OPERATOR_LEADER_ELECTION_LEASE_DURATION = KubernetesOperatorConfigOptions.operatorConfig("leader-election.lease-duration").durationType().defaultValue((Object)LeaderElectionConfiguration.LEASE_DURATION_DEFAULT_VALUE).withDescription("Leader election lease duration.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Duration> OPERATOR_LEADER_ELECTION_RENEW_DEADLINE = KubernetesOperatorConfigOptions.operatorConfig("leader-election.renew-deadline").durationType().defaultValue((Object)LeaderElectionConfiguration.RENEW_DEADLINE_DEFAULT_VALUE).withDescription("Leader election renew deadline.");
    @Documentation.Section(value={"system"})
    public static final ConfigOption<Duration> OPERATOR_LEADER_ELECTION_RETRY_PERIOD = KubernetesOperatorConfigOptions.operatorConfig("leader-election.retry-period").durationType().defaultValue((Object)LeaderElectionConfiguration.RETRY_PERIOD_DEFAULT_VALUE).withDescription("Leader election retry period.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Duration> OPERATOR_JM_SHUTDOWN_TTL = KubernetesOperatorConfigOptions.operatorConfig("jm-deployment.shutdown-ttl").durationType().defaultValue((Object)Duration.ofDays(1L)).withDescription("Time after which jobmanager pods of terminal application deployments are shut down.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Duration> CANARY_RESOURCE_TIMEOUT = KubernetesOperatorConfigOptions.operatorConfig("health.canary.resource.timeout").durationType().defaultValue((Object)Duration.ofMinutes(1L)).withDescription("Allowed max time between spec update and reconciliation for canary resources.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> OPERATOR_JM_STARTUP_PROBE_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("jm-deployment.startup.probe.enabled").booleanType().defaultValue((Object)true).withDescription("Enable job manager startup probe to allow detecting when the jobmanager could not submit the job.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> POD_TEMPLATE_MERGE_BY_NAME = KubernetesOperatorConfigOptions.operatorConfig("pod-template.merge-arrays-by-name").booleanType().defaultValue((Object)false).withDescription("Configure the array merge behaviour during pod merging. Arrays can be either merged by position or name matching.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<DeletionPropagation> RESOURCE_DELETION_PROPAGATION = KubernetesOperatorConfigOptions.operatorConfig("resource.deletion.propagation").enumType(DeletionPropagation.class).defaultValue((Object)DeletionPropagation.FOREGROUND).withDescription("JM/TM Deployment deletion propagation.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> SAVEPOINT_ON_DELETION = KubernetesOperatorConfigOptions.operatorConfig("job.savepoint-on-deletion").booleanType().defaultValue((Object)false).withDescription("Indicate whether a savepoint must be taken when deleting a FlinkDeployment or FlinkSessionJob.");
    @Documentation.Section(value={"dynamic"})
    public static final ConfigOption<Boolean> DRAIN_ON_SAVEPOINT_DELETION = KubernetesOperatorConfigOptions.operatorConfig("job.drain-on-savepoint-deletion").booleanType().defaultValue((Object)false).withDescription("Indicate whether the job should be drained when stopping with savepoint.");
    @Documentation.Section(value={"system_advanced"})
    public static final ConfigOption<Duration> REFRESH_CLUSTER_RESOURCE_VIEW = KubernetesOperatorConfigOptions.operatorConfig("cluster.resource-view.refresh-interval").durationType().defaultValue((Object)Duration.ofMinutes(-1L)).withDescription("How often to retrieve Kubernetes cluster resource usage information. This information is used to avoid running out of cluster resources when scaling up resources. Negative values disable the feature.");

    public static ConfigOptions.OptionBuilder operatorConfig(String key) {
        return ConfigOptions.key((String)(K8S_OP_CONF_PREFIX + key));
    }

    public static String operatorConfigKey(String key) {
        return K8S_OP_CONF_PREFIX + key;
    }
}

