/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.autoscaler.state;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigMapView {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMapView.class);
    private State state;
    private ConfigMap configMap;
    private final Function<ConfigMap, Resource<ConfigMap>> resourceRetriever;

    public ConfigMapView(ConfigMap configMapSkeleton, Function<ConfigMap, Resource<ConfigMap>> resourceRetriever) {
        ConfigMap existingConfigMap = (ConfigMap)resourceRetriever.apply(configMapSkeleton).get();
        if (existingConfigMap != null) {
            this.refreshConfigMap(existingConfigMap);
        } else {
            this.configMap = configMapSkeleton;
            this.state = State.NEEDS_CREATE;
        }
        this.resourceRetriever = resourceRetriever;
    }

    public String get(String key) {
        return (String)this.configMap.getData().get(key);
    }

    public void put(String key, String value) {
        this.configMap.getData().put(key, value);
        this.requireUpdate();
    }

    public void removeKey(String key) {
        String oldKey = (String)this.configMap.getData().remove(key);
        if (oldKey != null) {
            this.requireUpdate();
        }
    }

    public void clear() {
        if (this.configMap.getData().isEmpty()) {
            return;
        }
        this.configMap.getData().clear();
        this.requireUpdate();
    }

    public void flush() {
        if (this.state == State.UP_TO_DATE) {
            return;
        }
        Resource<ConfigMap> resource = this.resourceRetriever.apply(this.configMap);
        if (this.state == State.NEEDS_UPDATE) {
            this.refreshConfigMap((ConfigMap)resource.update());
        } else if (this.state == State.NEEDS_CREATE) {
            LOG.info("Creating config map {}", (Object)this.configMap.getMetadata().getName());
            this.refreshConfigMap((ConfigMap)resource.create());
        }
    }

    private void refreshConfigMap(ConfigMap configMap) {
        Preconditions.checkNotNull((Object)configMap);
        this.configMap = configMap;
        this.state = State.UP_TO_DATE;
    }

    private void requireUpdate() {
        if (this.state != State.NEEDS_CREATE) {
            this.state = State.NEEDS_UPDATE;
        }
    }

    @VisibleForTesting
    public Map<String, String> getDataReadOnly() {
        return Collections.unmodifiableMap(this.configMap.getData());
    }

    static enum State {
        NEEDS_CREATE,
        NEEDS_UPDATE,
        UP_TO_DATE;

    }
}

