/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.autoscaler;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.autoscaler.JobAutoScalerContext;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.function.SupplierWithException;

public class KubernetesJobAutoScalerContext
extends JobAutoScalerContext<ResourceID> {
    private final FlinkResourceContext<?> resourceContext;

    public KubernetesJobAutoScalerContext(@Nullable JobID jobID, @Nullable JobStatus jobStatus, Configuration configuration, MetricGroup metricGroup, SupplierWithException<RestClusterClient<String>, Exception> restClientSupplier, FlinkResourceContext<?> resourceContext) {
        super((Object)ResourceID.fromResource(resourceContext.getResource()), jobID, jobStatus, configuration, metricGroup, restClientSupplier);
        this.resourceContext = resourceContext;
    }

    public Optional<Double> getTaskManagerCpu() {
        return Optional.ofNullable((Double)this.getConfiguration().get(KubernetesConfigOptions.TASK_MANAGER_CPU));
    }

    public AbstractFlinkResource<?, ?> getResource() {
        return this.resourceContext.getResource();
    }

    public KubernetesClient getKubernetesClient() {
        return this.resourceContext.getKubernetesClient();
    }

    public FlinkResourceContext<?> getResourceContext() {
        return this.resourceContext;
    }
}

