/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job.metrics;

import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public final class IOMetricsInfo {
    public static final String FIELD_NAME_BYTES_READ = "read-bytes";
    private static final String FIELD_NAME_BYTES_READ_COMPLETE = "read-bytes-complete";
    public static final String FIELD_NAME_BYTES_WRITTEN = "write-bytes";
    private static final String FIELD_NAME_BYTES_WRITTEN_COMPLETE = "write-bytes-complete";
    public static final String FIELD_NAME_RECORDS_READ = "read-records";
    private static final String FIELD_NAME_RECORDS_READ_COMPLETE = "read-records-complete";
    public static final String FIELD_NAME_RECORDS_WRITTEN = "write-records";
    private static final String FIELD_NAME_RECORDS_WRITTEN_COMPLETE = "write-records-complete";
    public static final String FIELD_NAME_ACC_BACK_PRESSURE = "accumulated-backpressured-time";
    public static final String FIELD_NAME_ACC_IDLE = "accumulated-idle-time";
    public static final String FIELD_NAME_ACC_BUSY = "accumulated-busy-time";
    @JsonProperty(value="read-bytes")
    private final long bytesRead;
    @JsonProperty(value="read-bytes-complete")
    private final boolean bytesReadComplete;
    @JsonProperty(value="write-bytes")
    private final long bytesWritten;
    @JsonProperty(value="write-bytes-complete")
    private final boolean bytesWrittenComplete;
    @JsonProperty(value="read-records")
    private final long recordsRead;
    @JsonProperty(value="read-records-complete")
    private final boolean recordsReadComplete;
    @JsonProperty(value="write-records")
    private final long recordsWritten;
    @JsonProperty(value="write-records-complete")
    private final boolean recordsWrittenComplete;
    @JsonProperty(value="accumulated-backpressured-time")
    private final Long accumulatedBackpressured;
    @JsonProperty(value="accumulated-idle-time")
    private final Long accumulatedIdle;
    @JsonProperty(value="accumulated-busy-time")
    private final Double accumulatedBusy;

    @JsonCreator
    public IOMetricsInfo(@JsonProperty(value="read-bytes") long bytesRead, @JsonProperty(value="read-bytes-complete") boolean bytesReadComplete, @JsonProperty(value="write-bytes") long bytesWritten, @JsonProperty(value="write-bytes-complete") boolean bytesWrittenComplete, @JsonProperty(value="read-records") long recordsRead, @JsonProperty(value="read-records-complete") boolean recordsReadComplete, @JsonProperty(value="write-records") long recordsWritten, @JsonProperty(value="write-records-complete") boolean recordsWrittenComplete, @JsonProperty(value="accumulated-backpressured-time") Long accumulatedBackpressured, @JsonProperty(value="accumulated-idle-time") Long accumulatedIdle, @JsonProperty(value="accumulated-busy-time") Double accumulatedBusy) {
        this.bytesRead = bytesRead;
        this.bytesReadComplete = bytesReadComplete;
        this.bytesWritten = bytesWritten;
        this.bytesWrittenComplete = bytesWrittenComplete;
        this.recordsRead = recordsRead;
        this.recordsReadComplete = recordsReadComplete;
        this.recordsWritten = recordsWritten;
        this.recordsWrittenComplete = recordsWrittenComplete;
        this.accumulatedBackpressured = accumulatedBackpressured;
        this.accumulatedIdle = accumulatedIdle;
        this.accumulatedBusy = accumulatedBusy;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public boolean isBytesReadComplete() {
        return this.bytesReadComplete;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean isBytesWrittenComplete() {
        return this.bytesWrittenComplete;
    }

    public long getRecordsRead() {
        return this.recordsRead;
    }

    public boolean isRecordsReadComplete() {
        return this.recordsReadComplete;
    }

    public long getRecordsWritten() {
        return this.recordsWritten;
    }

    public boolean isRecordsWrittenComplete() {
        return this.recordsWrittenComplete;
    }

    public long getAccumulatedBackpressured() {
        return this.accumulatedBackpressured;
    }

    public double getAccumulatedBusy() {
        return this.accumulatedBusy;
    }

    public long getAccumulatedIdle() {
        return this.accumulatedIdle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOMetricsInfo that = (IOMetricsInfo)o;
        return this.bytesRead == that.bytesRead && this.bytesReadComplete == that.bytesReadComplete && this.bytesWritten == that.bytesWritten && this.bytesWrittenComplete == that.bytesWrittenComplete && this.recordsRead == that.recordsRead && this.recordsReadComplete == that.recordsReadComplete && this.recordsWritten == that.recordsWritten && this.recordsWrittenComplete == that.recordsWrittenComplete && this.accumulatedBackpressured == that.accumulatedBackpressured && this.accumulatedBusy == that.accumulatedBusy && this.accumulatedIdle == that.accumulatedIdle;
    }

    public int hashCode() {
        return Objects.hash(this.bytesRead, this.bytesReadComplete, this.bytesWritten, this.bytesWrittenComplete, this.recordsRead, this.recordsReadComplete, this.recordsWritten, this.recordsWrittenComplete, this.accumulatedBackpressured, this.accumulatedBusy, this.accumulatedIdle);
    }
}

