/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;
import org.apache.flink.kubernetes.operator.metrics.KubernetesClientMetrics;
import org.apache.flink.metrics.MetricGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesClientUtils.class);

    public static KubernetesClient getKubernetesClient(FlinkOperatorConfiguration operatorConfig, MetricGroup metricGroup) {
        return KubernetesClientUtils.getKubernetesClient(operatorConfig, metricGroup, null);
    }

    @VisibleForTesting
    public static KubernetesClient getKubernetesClient(final FlinkOperatorConfiguration operatorConfig, final MetricGroup metricGroup, Config kubernetesClientConfig) {
        KubernetesClientBuilder clientBuilder = new KubernetesClientBuilder().withConfig(kubernetesClientConfig);
        if (operatorConfig.isKubernetesClientMetricsEnabled()) {
            clientBuilder = clientBuilder.withHttpClientFactory((HttpClient.Factory)new OkHttpClientFactory(){

                protected void additionalConfig(OkHttpClient.Builder builder) {
                    builder.addInterceptor((Interceptor)new KubernetesClientMetrics(metricGroup, operatorConfig));
                }
            });
        }
        return clientBuilder.build();
    }
}

