/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.reconciler.diff;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.diff.DiffType;
import org.apache.flink.kubernetes.operator.api.diff.Diffable;
import org.apache.flink.kubernetes.operator.api.diff.SpecDiff;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.reconciler.diff.DiffBuilder;
import org.apache.flink.kubernetes.operator.reconciler.diff.DiffResult;

@Experimental
public class ReflectiveDiffBuilder<T>
implements Builder<DiffResult<T>> {
    private final KubernetesDeploymentMode deploymentMode;
    private final Object before;
    private final Object after;
    private final DiffBuilder<T> diffBuilder;

    public ReflectiveDiffBuilder(KubernetesDeploymentMode deploymentMode, @NonNull T before, @NonNull T after) {
        if (before == null) {
            throw new NullPointerException("before is marked non-null but is null");
        }
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        this.deploymentMode = deploymentMode;
        this.before = before;
        this.after = after;
        this.diffBuilder = new DiffBuilder<T>(before, after);
    }

    public DiffResult<T> build() {
        if (this.before.equals(this.after)) {
            return this.diffBuilder.build();
        }
        this.appendFields(this.before.getClass());
        return this.diffBuilder.build();
    }

    private void appendFields(Class<?> clazz) {
        for (Field field : FieldUtils.getAllFields(clazz)) {
            if (!this.accept(field)) continue;
            try {
                Object leftField = FieldUtils.readField((Field)field, (Object)this.before, (boolean)true);
                Object rightField = FieldUtils.readField((Field)field, (Object)this.after, (boolean)true);
                if (field.isAnnotationPresent(SpecDiff.Config.class) && Map.class.isAssignableFrom(field.getType())) {
                    this.diffBuilder.append(field.getName(), this.configDiff(field, leftField != null ? (Map)leftField : new HashMap(), rightField != null ? (Map)rightField : new HashMap()));
                    continue;
                }
                if (field.isAnnotationPresent(SpecDiff.class)) {
                    SpecDiff annotation = field.getAnnotation(SpecDiff.class);
                    KubernetesDeploymentMode[] modes = annotation.mode();
                    boolean modeApplies = modes.length == 0 || Arrays.asList(modes).contains(this.deploymentMode);
                    this.diffBuilder.append(field.getName(), leftField, rightField, modeApplies ? annotation.value() : DiffType.UPGRADE);
                    continue;
                }
                if (Diffable.class.isAssignableFrom(field.getType()) && ObjectUtils.allNotNull((Object[])new Object[]{leftField, rightField})) {
                    this.diffBuilder.append(field.getName(), (DiffResult<?>)new ReflectiveDiffBuilder<Object>(this.deploymentMode, leftField, rightField).build());
                    continue;
                }
                this.diffBuilder.append(field.getName(), FieldUtils.readField((Field)field, (Object)this.before, (boolean)true), FieldUtils.readField((Field)field, (Object)this.after, (boolean)true), DiffType.UPGRADE);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Unexpected IllegalAccessException: " + ex.getMessage(), ex);
            }
        }
    }

    private boolean accept(Field field) {
        if (field.getName().indexOf(36) != -1) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        return !Modifier.isStatic(field.getModifiers());
    }

    private DiffResult<Map<String, String>> configDiff(Field field, Map<String, String> left, Map<String, String> right) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(left.keySet());
        keys.addAll(right.keySet());
        DiffBuilder<Map<String, String>> diffBuilder = new DiffBuilder<Map<String, String>>(left, right);
        SpecDiff.Config annotation = field.getAnnotation(SpecDiff.Config.class);
        keys.forEach(key -> {
            if (annotation != null) {
                DiffType diffType = this.getType(annotation, (String)key);
                diffBuilder.append((String)key, left.get(key), right.get(key), diffType);
            } else {
                diffBuilder.append((String)key, left.get(key), right.get(key), DiffType.UPGRADE);
            }
        });
        return diffBuilder.build();
    }

    private DiffType getType(SpecDiff.Config annotation, String key) {
        DiffType diffType = DiffType.UPGRADE;
        for (SpecDiff.Entry entry : annotation.value()) {
            if (entry.mode().length > 0 && !Arrays.asList(entry.mode()).contains(this.deploymentMode) || !key.startsWith(entry.prefix())) continue;
            return entry.type();
        }
        return diffType;
    }
}

