/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.reconciler.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.zjsonpatch.JsonDiff;
import java.util.List;
import lombok.NonNull;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.diff.DiffType;
import org.apache.flink.kubernetes.operator.reconciler.diff.Diff;

@Experimental
public class DiffResult<T> {
    @NonNull
    private final List<Diff<?>> diffList;
    @NonNull
    private final T before;
    @NonNull
    private final T after;
    @NonNull
    private final DiffType type;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    DiffResult(@NonNull T before, @NonNull T after, @NonNull List<Diff<?>> diffList) {
        if (before == null) {
            throw new NullPointerException("before is marked non-null but is null");
        }
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        if (diffList == null) {
            throw new NullPointerException("diffList is marked non-null but is null");
        }
        this.before = before;
        this.after = after;
        this.diffList = diffList;
        this.type = DiffResult.getSpechChangeType(diffList);
    }

    public int getNumDiffs() {
        return this.diffList.size();
    }

    public String toString() {
        if (this.diffList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.before.getClass().getSimpleName()).append("[");
        this.diffList.forEach(diff -> {
            try {
                JsonNode diffBefore = objectMapper.readTree(objectMapper.writeValueAsString(diff.getLeft()));
                JsonNode diffAfter = objectMapper.readTree(objectMapper.writeValueAsString(diff.getRight()));
                JsonNode jsonDiff = JsonDiff.asJson((JsonNode)diffBefore, (JsonNode)diffAfter);
                jsonDiff.forEach(row -> {
                    DiffResult.addField(builder, diffBefore, diffAfter, diff.getFieldName(), row);
                    builder.append(", ");
                });
                builder.setLength(builder.length() - 2);
            }
            catch (Exception je) {
                builder.append(diff.getFieldName()).append(" : ").append(diff.getLeft()).append(" -> ").append(diff.getRight());
            }
            builder.append(", ");
        });
        builder.setLength(builder.length() - 2);
        builder.append("]");
        return String.format("Diff: %s", builder);
    }

    private static DiffType getSpechChangeType(List<Diff<?>> diffs) {
        DiffType type = DiffType.IGNORE;
        for (Diff<?> diff : diffs) {
            if ((type = DiffType.max((DiffType)type, (DiffType)diff.getType())) != DiffType.UPGRADE) continue;
            return type;
        }
        return type;
    }

    private static void addField(StringBuilder sb, JsonNode parentBefore, JsonNode parentAfter, String fieldName, JsonNode diff) {
        JsonNode beforeNode = parentBefore;
        JsonNode afterNode = parentAfter;
        String extraPath = "";
        if (!diff.get("path").asText().equals("/")) {
            extraPath = diff.get("path").asText().replaceAll("/", ".");
            beforeNode = beforeNode.at(diff.get("path").asText());
            afterNode = afterNode.at(diff.get("path").asText());
        }
        sb.append(fieldName).append(extraPath).append(" : ");
        if ((afterNode.isNull() || afterNode.isMissingNode()) && beforeNode.asText().equals("")) {
            sb.append("{..}");
        } else {
            sb.append(DiffResult.getText(beforeNode));
        }
        sb.append(" -> ").append(DiffResult.getText(afterNode));
    }

    private static String getText(JsonNode node) {
        if (node.isNull() || node.isMissingNode()) {
            return null;
        }
        String text = node.asText();
        return text.equals("") ? node.toString() : text;
    }

    @NonNull
    public List<Diff<?>> getDiffList() {
        return this.diffList;
    }

    @NonNull
    public T getBefore() {
        return this.before;
    }

    @NonNull
    public T getAfter() {
        return this.after;
    }

    @NonNull
    public DiffType getType() {
        return this.type;
    }
}

