/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.reconciler.deployment;

import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.autoscaler.JobAutoScaler;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.autoscaler.KubernetesJobAutoScalerContext;
import org.apache.flink.kubernetes.operator.config.Mode;
import org.apache.flink.kubernetes.operator.reconciler.Reconciler;
import org.apache.flink.kubernetes.operator.reconciler.deployment.ApplicationReconciler;
import org.apache.flink.kubernetes.operator.reconciler.deployment.SessionReconciler;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.StatusRecorder;

public class ReconcilerFactory {
    private final EventRecorder eventRecorder;
    private final StatusRecorder<FlinkDeployment, FlinkDeploymentStatus> deploymentStatusRecorder;
    private final JobAutoScaler<ResourceID, KubernetesJobAutoScalerContext> autoscaler;
    private final Map<Tuple2<Mode, KubernetesDeploymentMode>, Reconciler<FlinkDeployment>> reconcilerMap;

    public ReconcilerFactory(EventRecorder eventRecorder, StatusRecorder<FlinkDeployment, FlinkDeploymentStatus> deploymentStatusRecorder, JobAutoScaler<ResourceID, KubernetesJobAutoScalerContext> autoscaler) {
        this.eventRecorder = eventRecorder;
        this.deploymentStatusRecorder = deploymentStatusRecorder;
        this.autoscaler = autoscaler;
        this.reconcilerMap = new ConcurrentHashMap<Tuple2<Mode, KubernetesDeploymentMode>, Reconciler<FlinkDeployment>>();
    }

    public Reconciler<FlinkDeployment> getOrCreate(FlinkDeployment flinkApp) {
        return this.reconcilerMap.computeIfAbsent((Tuple2<Mode, KubernetesDeploymentMode>)Tuple2.of((Object)((Object)Mode.getMode(flinkApp)), (Object)KubernetesDeploymentMode.getDeploymentMode((FlinkDeployment)flinkApp)), modes -> {
            switch ((Mode)((Object)((Object)modes.f0))) {
                case SESSION: {
                    return new SessionReconciler(this.eventRecorder, this.deploymentStatusRecorder);
                }
                case APPLICATION: {
                    return new ApplicationReconciler(this.eventRecorder, this.deploymentStatusRecorder, this.autoscaler);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported running mode: %s", modes.f0));
        });
    }
}

