/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer.deployment;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.exception.UnknownJobException;
import org.apache.flink.kubernetes.operator.observer.ClusterHealthObserver;
import org.apache.flink.kubernetes.operator.observer.JobStatusObserver;
import org.apache.flink.kubernetes.operator.observer.SnapshotObserver;
import org.apache.flink.kubernetes.operator.observer.deployment.AbstractFlinkDeploymentObserver;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.runtime.client.JobStatusMessage;

public class ApplicationObserver
extends AbstractFlinkDeploymentObserver {
    private final SnapshotObserver<FlinkDeployment, FlinkDeploymentStatus> savepointObserver;
    private final JobStatusObserver<FlinkDeployment> jobStatusObserver;
    private final ClusterHealthObserver clusterHealthObserver;

    public ApplicationObserver(EventRecorder eventRecorder) {
        super(eventRecorder);
        this.savepointObserver = new SnapshotObserver(eventRecorder);
        this.jobStatusObserver = new ApplicationJobObserver(eventRecorder);
        this.clusterHealthObserver = new ClusterHealthObserver();
    }

    @Override
    protected void observeFlinkCluster(FlinkResourceContext<FlinkDeployment> ctx) {
        this.logger.debug("Observing application cluster");
        boolean jobFound = this.jobStatusObserver.observe(ctx);
        if (jobFound) {
            Configuration observeConfig = ctx.getObserveConfig();
            this.savepointObserver.observeSavepointStatus(ctx);
            this.savepointObserver.observeCheckpointStatus(ctx);
            if (observeConfig.getBoolean(KubernetesOperatorConfigOptions.OPERATOR_CLUSTER_HEALTH_CHECK_ENABLED)) {
                this.clusterHealthObserver.observe(ctx);
            }
        }
    }

    private class ApplicationJobObserver
    extends JobStatusObserver<FlinkDeployment> {
        public ApplicationJobObserver(EventRecorder eventRecorder) {
            super(eventRecorder);
        }

        @Override
        public void onTimeout(FlinkResourceContext<FlinkDeployment> ctx) {
            ApplicationObserver.this.observeJmDeployment(ctx);
        }

        @Override
        protected Optional<JobStatusMessage> filterTargetJob(org.apache.flink.kubernetes.operator.api.status.JobStatus status, List<JobStatusMessage> clusterJobStatuses) {
            if (!clusterJobStatuses.isEmpty()) {
                clusterJobStatuses.sort(Comparator.comparingLong(JobStatusMessage::getStartTime).reversed());
                return Optional.of(clusterJobStatuses.get(0));
            }
            return Optional.empty();
        }

        @Override
        protected void onTargetJobNotFound(FlinkResourceContext<FlinkDeployment> ctx) {
            this.setUnknownJobError(ctx);
        }

        private void setUnknownJobError(FlinkResourceContext<FlinkDeployment> ctx) {
            ((FlinkDeploymentStatus)ctx.getResource().getStatus()).getJobStatus().setState(JobStatus.RECONCILING.name());
            String err = "Unrecognized Job for Application deployment";
            ApplicationObserver.this.logger.error(err);
            ReconciliationUtils.updateForReconciliationError(ctx, new UnknownJobException(err));
            this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)ctx.getResource(), EventRecorder.Type.Warning, EventRecorder.Reason.Missing, EventRecorder.Component.Job, err, ctx.getKubernetesClient());
        }
    }
}

