/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics.lifecycle;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.kubernetes.operator.api.lifecycle.ResourceLifecycleState;
import org.apache.flink.kubernetes.operator.metrics.lifecycle.LifecycleMetrics;
import org.apache.flink.metrics.Histogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLifecycleMetricTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceLifecycleMetricTracker.class);
    private final Map<String, List<Histogram>> transitionHistos;
    private final Map<ResourceLifecycleState, List<Histogram>> stateTimeHistos;
    private final Map<ResourceLifecycleState, Tuple2<Instant, Instant>> stateTimeMap = new HashMap<ResourceLifecycleState, Tuple2<Instant, Instant>>();
    private ResourceLifecycleState currentState;

    public ResourceLifecycleMetricTracker(ResourceLifecycleState initialState, Instant time, Map<String, List<Histogram>> transitionHistos, Map<ResourceLifecycleState, List<Histogram>> stateTimeHistos) {
        this.transitionHistos = transitionHistos;
        this.currentState = initialState;
        this.stateTimeHistos = stateTimeHistos;
        this.updateCurrentState(this.currentState, time);
    }

    public void onUpdate(ResourceLifecycleState newState, Instant time) {
        if (newState == this.currentState) {
            this.updateCurrentState(newState, time);
            return;
        }
        LifecycleMetrics.TRACKED_TRANSITIONS.stream().filter(t -> t.to == newState).forEach(transition -> {
            Tuple2<Instant, Instant> fromTimes = this.stateTimeMap.get(transition.from);
            if (fromTimes != null) {
                long transitionTime = Duration.between(transition.measureFromLastUpdate ? (Temporal)fromTimes.f1 : (Temporal)fromTimes.f0, time).toSeconds();
                LOG.debug("Recording transition time {} for {} ({} -> {})", new Object[]{transitionTime, transition.metricName, transition.from, transition.to});
                this.transitionHistos.get(transition.metricName).forEach(h -> h.update(transitionTime));
            }
        });
        this.updateCurrentState(newState, time);
    }

    private void updateCurrentState(ResourceLifecycleState newState, Instant time) {
        this.stateTimeMap.compute(newState, (s, t) -> {
            if (t == null) {
                return Tuple2.of((Object)time, (Object)time);
            }
            if (newState != this.currentState) {
                t.f0 = time;
            }
            t.f1 = time;
            return t;
        });
        if (newState == this.currentState) {
            return;
        }
        Set toClear = newState.getClearedStatesAfterTransition(this.currentState);
        LOG.debug("Transitioned from {} to {}, clearing times for {}", new Object[]{this.currentState, newState, toClear});
        toClear.forEach(state -> {
            Tuple2<Instant, Instant> times = this.stateTimeMap.remove(state);
            if (times != null) {
                long totalSeconds = Duration.between((Temporal)times.f0, (Temporal)times.f1).toSeconds();
                this.stateTimeHistos.get(state).forEach(h -> h.update(totalSeconds));
            }
        });
        this.currentState = newState;
    }

    public ResourceLifecycleState getCurrentState() {
        return this.currentState;
    }

    @VisibleForTesting
    protected Map<String, List<Histogram>> getTransitionHistos() {
        return this.transitionHistos;
    }

    @VisibleForTesting
    protected Map<ResourceLifecycleState, List<Histogram>> getStateTimeHistos() {
        return this.stateTimeHistos;
    }
}

