/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricGroup;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricOptions;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceMetricGroup;
import org.apache.flink.kubernetes.operator.utils.EnvUtils;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.View;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorMetricUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorMetricUtils.class);
    private static final String OPERATOR_METRICS_PREFIX = "kubernetes.operator.metrics.";
    private static final String METRICS_PREFIX = "metrics.";

    public static KubernetesOperatorMetricGroup initOperatorMetrics(Configuration defaultConfig) {
        Configuration metricConfig = OperatorMetricUtils.createMetricConfig(defaultConfig);
        LOG.info("Initializing operator metrics using conf: {}", (Object)metricConfig);
        PluginManager pluginManager = PluginUtils.createPluginManagerFromRootFolder((Configuration)metricConfig);
        MetricRegistryImpl metricRegistry = OperatorMetricUtils.createMetricRegistry(metricConfig, pluginManager);
        KubernetesOperatorMetricGroup operatorMetricGroup = KubernetesOperatorMetricGroup.create((MetricRegistry)metricRegistry, metricConfig, EnvUtils.getOrDefault("OPERATOR_NAMESPACE", "default"), EnvUtils.getOrDefault("OPERATOR_NAME", "flink-kubernetes-operator"), EnvUtils.getOrDefault("HOSTNAME", "localhost"));
        if (defaultConfig.getBoolean(KubernetesOperatorMetricOptions.OPERATOR_JVM_METRICS_ENABLED)) {
            MetricGroup statusGroup = operatorMetricGroup.addGroup("Status");
            MetricUtils.instantiateStatusMetrics((MetricGroup)statusGroup);
        }
        return operatorMetricGroup;
    }

    public static KubernetesResourceMetricGroup createResourceMetricGroup(KubernetesOperatorMetricGroup operatorMetricGroup, FlinkConfigManager configManager, AbstractFlinkResource<?, ?> resource) {
        return operatorMetricGroup.createResourceNamespaceGroup(configManager.getDefaultConfig(), resource.getClass(), resource.getMetadata().getNamespace()).createResourceGroup(configManager.getDefaultConfig(), resource.getMetadata().getName());
    }

    @VisibleForTesting
    protected static Configuration createMetricConfig(Configuration defaultConfig) {
        HashMap metricConf = new HashMap();
        defaultConfig.toMap().forEach((key, value) -> {
            if (key.startsWith(OPERATOR_METRICS_PREFIX)) {
                metricConf.put(key.replaceFirst(OPERATOR_METRICS_PREFIX, METRICS_PREFIX), value);
            } else if (!key.startsWith(METRICS_PREFIX)) {
                metricConf.put(key, value);
            }
        });
        return Configuration.fromMap(metricConf);
    }

    private static MetricRegistryImpl createMetricRegistry(Configuration configuration, PluginManager pluginManager) {
        return new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)configuration, (long)Long.MAX_VALUE), (Collection)ReporterSetup.fromConfiguration((Configuration)configuration, (PluginManager)pluginManager));
    }

    public static Counter synchronizedCounter(Counter counter) {
        return new SynchronizedCounter(counter);
    }

    public static SynchronizedMeterView synchronizedMeterView(MeterView meterView) {
        return new SynchronizedMeterView(meterView);
    }

    public static Histogram createHistogram(FlinkOperatorConfiguration operatorConfiguration) {
        return new DescriptiveStatisticsHistogram(operatorConfiguration.getMetricsHistogramSampleSize());
    }

    public static class SynchronizedMeterView
    implements Meter,
    View {
        private final MeterView delegate;

        public SynchronizedMeterView(MeterView delegate) {
            this.delegate = delegate;
        }

        public synchronized void markEvent() {
            this.delegate.markEvent();
        }

        public synchronized void markEvent(long l) {
            this.delegate.markEvent(l);
        }

        public synchronized double getRate() {
            return this.delegate.getRate();
        }

        public synchronized long getCount() {
            return this.delegate.getCount();
        }

        public synchronized void update() {
            this.delegate.update();
        }
    }

    public static class SynchronizedCounter
    implements Counter {
        private final Counter delegate;

        public SynchronizedCounter(Counter delegate) {
            this.delegate = delegate;
        }

        public synchronized void inc() {
            this.delegate.inc();
        }

        public synchronized void inc(long l) {
            this.delegate.inc(l);
        }

        public synchronized void dec() {
            this.delegate.dec();
        }

        public synchronized void dec(long l) {
            this.delegate.dec(l);
        }

        public synchronized long getCount() {
            return this.delegate.getCount();
        }
    }

    public static class SynchronizedHistogram
    implements Histogram {
        private final Histogram delegate;

        public SynchronizedHistogram(Histogram delegate) {
            this.delegate = delegate;
        }

        public synchronized void update(long l) {
            this.delegate.update(l);
        }

        public synchronized long getCount() {
            return this.delegate.getCount();
        }

        public synchronized HistogramStatistics getStatistics() {
            return this.delegate.getStatistics();
        }
    }
}

