/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricOptions;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorScopeFormat;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceNamespaceScopeFormat;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;

public class KubernetesResourceScopeFormat
extends ScopeFormat {
    public static final String RESOURCE = KubernetesResourceScopeFormat.asVariable((String)"resourcename");

    public KubernetesResourceScopeFormat(String format) {
        super(format, null, new String[]{KubernetesOperatorScopeFormat.NAMESPACE, KubernetesOperatorScopeFormat.NAME, SCOPE_HOST, KubernetesResourceNamespaceScopeFormat.RESOURCE_NS, RESOURCE, KubernetesResourceNamespaceScopeFormat.RESOURCE_TYPE});
    }

    public String[] formatScope(String namespace, String name, String hostname, String resourceNs, String resourceName, String resourceType) {
        String[] template = this.copyTemplate();
        String[] values = new String[]{namespace, name, hostname, resourceNs, resourceName, resourceType};
        return this.bindVariables(template, values);
    }

    public static KubernetesResourceScopeFormat fromConfig(Configuration config) {
        String format = config.getString(KubernetesOperatorMetricOptions.SCOPE_NAMING_KUBERNETES_OPERATOR_RESOURCE);
        return new KubernetesResourceScopeFormat(format);
    }
}

