/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricOptions;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorScopeFormat;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;

public class KubernetesResourceNamespaceScopeFormat
extends ScopeFormat {
    public static final String RESOURCE_NS = KubernetesResourceNamespaceScopeFormat.asVariable((String)"resourcens");
    public static final String RESOURCE_TYPE = KubernetesResourceNamespaceScopeFormat.asVariable((String)"resourcetype");

    public KubernetesResourceNamespaceScopeFormat(String format) {
        super(format, null, new String[]{KubernetesOperatorScopeFormat.NAMESPACE, KubernetesOperatorScopeFormat.NAME, SCOPE_HOST, RESOURCE_NS, RESOURCE_TYPE});
    }

    public String[] formatScope(String namespace, String name, String hostname, String resourceNs, String resourceType) {
        String[] template = this.copyTemplate();
        String[] values = new String[]{namespace, name, hostname, resourceNs, resourceType};
        return this.bindVariables(template, values);
    }

    public static KubernetesResourceNamespaceScopeFormat fromConfig(Configuration config) {
        String format = config.getString(KubernetesOperatorMetricOptions.SCOPE_NAMING_KUBERNETES_OPERATOR_RESOURCENS);
        return new KubernetesResourceNamespaceScopeFormat(format);
    }
}

