/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.kubernetes.operator.api.listener.FlinkResourceListener;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerUtils.class);
    private static final String PREFIX = "kubernetes.operator.plugins.listeners.";
    private static final String SUFFIX = ".class";
    private static final Pattern PTN = Pattern.compile(Pattern.quote("kubernetes.operator.plugins.listeners.") + "([\\S&&[^.]]*)" + Pattern.quote(".class"));
    private static final List<String> EXTRA_PARENT_FIRST_PATTERNS = List.of("io.fabric8", "com.fasterxml");

    public static Collection<FlinkResourceListener> discoverListeners(FlinkConfigManager configManager) {
        ArrayList<FlinkResourceListener> listeners = new ArrayList<FlinkResourceListener>();
        Configuration conf = ListenerUtils.getListenerBaseConf(configManager);
        Map<String, Configuration> listenerConfigs = ListenerUtils.loadListenerConfigs(conf);
        PluginUtils.createPluginManagerFromRootFolder((Configuration)conf).load(FlinkResourceListener.class).forEachRemaining(listener -> {
            String clazz = listener.getClass().getName();
            LOG.info("Discovered resource listener from plugin directory[{}]: {}.", (Object)System.getenv().getOrDefault("FLINK_PLUGINS_DIR", "plugins"), (Object)clazz);
            if (listenerConfigs.containsKey(clazz)) {
                LOG.info("Initializing {}", (Object)clazz);
                listener.configure((Configuration)listenerConfigs.get(clazz));
                listeners.add((FlinkResourceListener)listener);
            } else {
                LOG.warn("No configuration found for {}", (Object)clazz);
            }
        });
        return listeners;
    }

    private static Configuration getListenerBaseConf(FlinkConfigManager configManager) {
        Configuration conf = new Configuration(configManager.getDefaultConfig());
        ArrayList<String> additionalPatterns = new ArrayList<String>(conf.getOptional(CoreOptions.PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL).orElse(Collections.emptyList()));
        additionalPatterns.addAll(EXTRA_PARENT_FIRST_PATTERNS);
        conf.set(CoreOptions.PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL, additionalPatterns);
        return conf;
    }

    @VisibleForTesting
    protected static Map<String, Configuration> loadListenerConfigs(Configuration configuration) {
        HashMap<String, Configuration> listenerConfigs = new HashMap<String, Configuration>();
        for (Tuple2<String, String> enableListeners : ListenerUtils.findEnabledListeners(configuration)) {
            DelegatingConfiguration delegatingConfiguration = new DelegatingConfiguration(configuration, PREFIX + (String)enableListeners.f0 + ".");
            listenerConfigs.put((String)enableListeners.f1, (Configuration)delegatingConfiguration);
        }
        return listenerConfigs;
    }

    private static Set<Tuple2<String, String>> findEnabledListeners(Configuration configuration) {
        HashSet<Tuple2<String, String>> result = new HashSet<Tuple2<String, String>>();
        for (String key : configuration.keySet()) {
            Matcher matcher = PTN.matcher(key);
            if (!matcher.matches()) continue;
            result.add((Tuple2<String, String>)Tuple2.of((Object)matcher.group(1), (Object)((String)configuration.get(ConfigOptions.key((String)key).stringType().noDefaultValue()))));
        }
        return result;
    }
}

