/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.fs;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemWatchService
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemWatchService.class);
    private final String directoryPath;

    public FileSystemWatchService(String directoryPath) {
        if (!new File(directoryPath).isDirectory()) {
            throw new IllegalArgumentException("Directory must exists: " + directoryPath);
        }
        this.directoryPath = directoryPath;
    }

    @Override
    public void run() {
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            try {
                LOG.info("Starting watching path: " + this.directoryPath);
                Path realDirectoryPath = Paths.get(this.directoryPath, new String[0]).toRealPath(new LinkOption[0]);
                LOG.info("Path is resolved to real path: " + realDirectoryPath);
                realDirectoryPath.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.onWatchStarted(realDirectoryPath);
                while (true) {
                    LOG.debug("Taking watch key");
                    WatchKey watchKey = watcher.take();
                    LOG.debug("Watch key arrived");
                    for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                        LOG.debug("Watch event count: " + watchEvent.count());
                        if (watchEvent.kind() == StandardWatchEventKinds.OVERFLOW) {
                            LOG.error("Filesystem events may have been lost or discarded");
                            Thread.yield();
                            continue;
                        }
                        if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                            this.onFileOrDirectoryCreated((Path)watchEvent.context());
                            continue;
                        }
                        if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                            this.onFileOrDirectoryDeleted((Path)watchEvent.context());
                            continue;
                        }
                        if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                            this.onFileOrDirectoryModified((Path)watchEvent.context());
                            continue;
                        }
                        throw new IllegalStateException("Invalid event kind: " + watchEvent.kind());
                    }
                    watchKey.reset();
                }
            }
            catch (Throwable throwable) {
                if (watcher != null) {
                    try {
                        watcher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            LOG.info("Filesystem watcher interrupted");
        }
        catch (Exception e) {
            LOG.error("Filesystem watcher received exception and stopped: " + e);
            throw new RuntimeException(e);
        }
    }

    protected void onWatchStarted(Path realDirectoryPath) {
    }

    protected void onFileOrDirectoryCreated(Path relativePath) {
    }

    protected void onFileOrDirectoryDeleted(Path relativePath) {
    }

    protected void onFileOrDirectoryModified(Path relativePath) {
    }
}

