/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.controller;

import io.javaoperatorsdk.operator.api.reconciler.Context;
import java.util.function.Function;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.spec.AbstractFlinkSpec;
import org.apache.flink.kubernetes.operator.api.spec.FlinkDeploymentSpec;
import org.apache.flink.kubernetes.operator.api.spec.FlinkVersion;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceMetricGroup;
import org.apache.flink.kubernetes.operator.service.FlinkService;

public class FlinkDeploymentContext
extends FlinkResourceContext<FlinkDeployment> {
    public FlinkDeploymentContext(FlinkDeployment resource, Context<?> josdkContext, KubernetesResourceMetricGroup resourceMetricGroup, FlinkConfigManager configManager, Function<FlinkResourceContext<?>, FlinkService> flinkServiceFactory) {
        super(resource, josdkContext, resourceMetricGroup, configManager, flinkServiceFactory);
    }

    @Override
    public Configuration getDeployConfig(AbstractFlinkSpec spec) {
        return this.configManager.getDeployConfig(((FlinkDeployment)this.getResource()).getMetadata(), (FlinkDeploymentSpec)spec);
    }

    @Override
    protected Configuration createObserveConfig() {
        return this.configManager.getObserveConfig((FlinkDeployment)this.getResource());
    }

    @Override
    public KubernetesDeploymentMode getDeploymentMode() {
        return KubernetesDeploymentMode.getDeploymentMode((FlinkDeployment)((FlinkDeployment)this.getResource()));
    }

    @Override
    public FlinkVersion getFlinkVersion() {
        return ((FlinkDeploymentSpec)((FlinkDeployment)this.getResource()).getSpec()).getFlinkVersion();
    }
}

