/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.autoscaler.state;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.autoscaler.KubernetesJobAutoScalerContext;
import org.apache.flink.kubernetes.operator.autoscaler.state.ConfigMapView;
import org.apache.flink.kubernetes.operator.autoscaler.state.KubernetesAutoScalerStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapStore {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesAutoScalerStateStore.class);
    private static final String LABEL_COMPONENT_AUTOSCALER = "autoscaler";
    private final KubernetesClient kubernetesClient;
    private final ConcurrentHashMap<ResourceID, ConfigMapView> cache = new ConcurrentHashMap();

    public ConfigMapStore(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    protected void putSerializedState(KubernetesJobAutoScalerContext jobContext, String key, String value) {
        this.getConfigMap(jobContext).put(key, value);
    }

    protected Optional<String> getSerializedState(KubernetesJobAutoScalerContext jobContext, String key) {
        return Optional.ofNullable(this.getConfigMap(jobContext).get(key));
    }

    protected void removeSerializedState(KubernetesJobAutoScalerContext jobContext, String key) {
        this.getConfigMap(jobContext).removeKey(key);
    }

    public void clearAll(KubernetesJobAutoScalerContext jobContext) {
        this.getConfigMap(jobContext).clear();
    }

    public void flush(KubernetesJobAutoScalerContext jobContext) {
        ConfigMapView configMapView = this.cache.get(jobContext.getJobKey());
        if (configMapView == null) {
            LOG.debug("The configMap doesn't exist, so skip the flush.");
            return;
        }
        try {
            configMapView.flush();
        }
        catch (Exception e) {
            LOG.error("Error while updating autoscaler info configmap, invalidating to clear the cache", (Throwable)e);
            this.removeInfoFromCache((ResourceID)jobContext.getJobKey());
            throw e;
        }
    }

    public void removeInfoFromCache(ResourceID resourceID) {
        this.cache.remove(resourceID);
    }

    private ConfigMapView getConfigMap(KubernetesJobAutoScalerContext jobContext) {
        return this.cache.computeIfAbsent((ResourceID)jobContext.getJobKey(), id -> this.getConfigMapFromKubernetes(jobContext));
    }

    @VisibleForTesting
    ConfigMapView getConfigMapFromKubernetes(KubernetesJobAutoScalerContext jobContext) {
        AbstractFlinkResource<?, ?> cr = jobContext.getResource();
        ObjectMeta meta = this.createCmObjectMeta(ResourceID.fromResource(cr));
        ConfigMap configMapSkeleton = this.buildConfigMap((HasMetadata)cr, meta);
        return new ConfigMapView(configMapSkeleton, arg_0 -> ((KubernetesClient)this.kubernetesClient).resource(arg_0));
    }

    private ObjectMeta createCmObjectMeta(ResourceID uid) {
        ObjectMeta objectMeta = new ObjectMeta();
        objectMeta.setName("autoscaler-" + uid.getName());
        uid.getNamespace().ifPresent(arg_0 -> ((ObjectMeta)objectMeta).setNamespace(arg_0));
        objectMeta.setLabels(Map.of("component", LABEL_COMPONENT_AUTOSCALER, "app", uid.getName()));
        return objectMeta;
    }

    private ConfigMap buildConfigMap(HasMetadata cr, ObjectMeta meta) {
        ConfigMap cm = new ConfigMap();
        cm.setMetadata(meta);
        cm.addOwnerReference(cr);
        cm.setData(new HashMap());
        return cm;
    }

    @VisibleForTesting
    protected ConcurrentHashMap<ResourceID, ConfigMapView> getCache() {
        return this.cache;
    }
}

