/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.autoscaler;

import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.autoscaler.JobAutoScalerContext;
import org.apache.flink.autoscaler.ScalingSummary;
import org.apache.flink.autoscaler.event.AutoScalerEventHandler;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.autoscaler.KubernetesJobAutoScalerContext;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class KubernetesAutoScalerEventHandler
implements AutoScalerEventHandler<ResourceID, KubernetesJobAutoScalerContext> {
    public static final String PARALLELISM_MAP_KEY = "parallelismMap";
    private final EventRecorder eventRecorder;

    public KubernetesAutoScalerEventHandler(EventRecorder eventRecorder) {
        this.eventRecorder = eventRecorder;
    }

    public void handleEvent(KubernetesJobAutoScalerContext context, AutoScalerEventHandler.Type type, String reason, String message, @Nullable String messageKey, @Nullable Duration interval) {
        this.eventRecorder.triggerEventWithInterval(context.getResource(), EventRecorder.Type.valueOf(type.name()), reason, message, EventRecorder.Component.Operator, messageKey, context.getKubernetesClient(), interval);
    }

    public void handleScalingEvent(KubernetesJobAutoScalerContext context, final Map<JobVertexID, ScalingSummary> scalingSummaries, boolean scaled, Duration interval) {
        if (scaled) {
            super.handleScalingEvent((JobAutoScalerContext)context, scalingSummaries, scaled, null);
        } else {
            Configuration conf = context.getConfiguration();
            String scalingReport = AutoScalerEventHandler.scalingReport(scalingSummaries, (boolean)scaled);
            Map<String, String> labels = Map.of(PARALLELISM_MAP_KEY, KubernetesAutoScalerEventHandler.getParallelismHashCode(scalingSummaries));
            Predicate<Map<String, String>> dedupePredicate = new Predicate<Map<String, String>>(){

                @Override
                public boolean test(Map<String, String> stringStringMap) {
                    return stringStringMap != null && Objects.equals(stringStringMap.get(KubernetesAutoScalerEventHandler.PARALLELISM_MAP_KEY), KubernetesAutoScalerEventHandler.getParallelismHashCode(scalingSummaries));
                }
            };
            this.eventRecorder.triggerEventWithLabels(context.getResource(), EventRecorder.Type.Normal, "ScalingReport", scalingReport, EventRecorder.Component.Operator, "ScalingExecutor", context.getKubernetesClient(), interval, dedupePredicate, labels);
        }
    }

    private static String getParallelismHashCode(Map<JobVertexID, ScalingSummary> scalingSummaryHashMap) {
        return Integer.toString(scalingSummaryHashMap.entrySet().stream().collect(Collectors.toMap(e -> ((JobVertexID)e.getKey()).toString(), e -> String.format("Parallelism %d -> %d", ((ScalingSummary)e.getValue()).getCurrentParallelism(), ((ScalingSummary)e.getValue()).getNewParallelism()))).hashCode() & Integer.MAX_VALUE);
    }
}

