/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.artifact;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.kubernetes.operator.artifact.ArtifactFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemBasedArtifactFetcher
implements ArtifactFetcher {
    public static final Logger LOG = LoggerFactory.getLogger(FileSystemBasedArtifactFetcher.class);
    public static final FileSystemBasedArtifactFetcher INSTANCE = new FileSystemBasedArtifactFetcher();

    @Override
    public File fetch(String uri, Configuration flinkConfiguration, File targetDir) throws Exception {
        Path source = new Path(uri);
        long start = System.currentTimeMillis();
        FileSystem fileSystem = source.getFileSystem();
        String fileName = source.getName();
        File targetFile = new File(targetDir, fileName);
        try (FSDataInputStream inputStream = fileSystem.open(source);){
            FileUtils.copyToFile((InputStream)inputStream, (File)targetFile);
        }
        LOG.debug("Copied file from {} to {}, cost {} ms", new Object[]{source, targetFile, System.currentTimeMillis() - start});
        return targetFile;
    }
}

