/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.utils.FlinkUtils;
import org.apache.flink.kubernetes.operator.validation.DefaultValidator;
import org.apache.flink.kubernetes.operator.validation.FlinkResourceValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidatorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkUtils.class);

    public static Set<FlinkResourceValidator> discoverValidators(FlinkConfigManager configManager) {
        HashSet<FlinkResourceValidator> resourceValidators = new HashSet<FlinkResourceValidator>();
        DefaultValidator defaultValidator = new DefaultValidator(configManager);
        defaultValidator.configure(configManager.getDefaultConfig());
        resourceValidators.add(defaultValidator);
        PluginUtils.createPluginManagerFromRootFolder((Configuration)configManager.getDefaultConfig()).load(FlinkResourceValidator.class).forEachRemaining(validator -> {
            LOG.info("Discovered resource validator from plugin directory[{}]: {}.", (Object)System.getenv().getOrDefault("FLINK_PLUGINS_DIR", "plugins"), (Object)validator.getClass().getName());
            validator.configure(configManager.getDefaultConfig());
            resourceValidators.add((FlinkResourceValidator)validator);
        });
        return resourceValidators;
    }
}

