/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValueBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRule;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.kubernetes.operator.api.spec.FlinkDeploymentSpec;
import org.apache.flink.kubernetes.operator.exception.ReconciliationException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngressUtils {
    private static final Pattern NAME_PTN = Pattern.compile("\\{\\{name\\}\\}", 2);
    private static final Pattern NAMESPACE_PTN = Pattern.compile("\\{\\{namespace\\}\\}", 2);
    private static final Pattern URL_PROTOCOL_REGEX = Pattern.compile("^https?://", 2);
    private static final String REST_SVC_NAME_SUFFIX = "-rest";
    private static final Logger LOG = LoggerFactory.getLogger(IngressUtils.class);

    public static void updateIngressRules(ObjectMeta objectMeta, FlinkDeploymentSpec spec, Configuration effectiveConfig, KubernetesClient client) {
        if (spec.getIngress() != null) {
            Ingress ingress = ((IngressBuilder)((IngressFluent.SpecNested)((IngressFluent.SpecNested)((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withAnnotations(spec.getIngress().getAnnotations())).withName(objectMeta.getName())).withNamespace(objectMeta.getNamespace())).endMetadata()).withNewSpec().withIngressClassName(spec.getIngress().getClassName())).withRules(new IngressRule[]{IngressUtils.getIngressRule(objectMeta, spec, effectiveConfig)})).endSpec()).build();
            Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(objectMeta.getNamespace())).withName(objectMeta.getName())).get();
            if (deployment == null) {
                LOG.error("Could not find deployment {}", (Object)objectMeta.getName());
            } else {
                IngressUtils.setOwnerReference((HasMetadata)deployment, Collections.singletonList(ingress));
            }
            LOG.info("Updating ingress rules {}", (Object)ingress);
            ((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.resourceList(new HasMetadata[]{ingress}).inNamespace(objectMeta.getNamespace())).createOrReplace();
        }
    }

    private static IngressRule getIngressRule(ObjectMeta objectMeta, FlinkDeploymentSpec spec, Configuration effectiveConfig) {
        String clusterId = objectMeta.getName();
        int restPort = effectiveConfig.getInteger(RestOptions.PORT);
        URL ingressUrl = IngressUtils.getIngressUrl(spec.getIngress().getTemplate(), objectMeta.getName(), objectMeta.getNamespace());
        IngressRuleBuilder ingressRuleBuilder = new IngressRuleBuilder();
        ingressRuleBuilder.withHttp(((HTTPIngressRuleValueBuilder)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)((HTTPIngressRuleValueFluent.PathsNested)new HTTPIngressRuleValueBuilder().addNewPath().withPathType("ImplementationSpecific")).withNewBackend().withNewService().withName(clusterId + REST_SVC_NAME_SUFFIX)).withNewPort().withNumber(Integer.valueOf(restPort))).endPort()).endService()).endBackend()).endPath()).build());
        if (!StringUtils.isBlank((CharSequence)ingressUrl.getHost())) {
            ingressRuleBuilder.withHost(ingressUrl.getHost());
        }
        if (!StringUtils.isBlank((CharSequence)ingressUrl.getPath())) {
            ((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)ingressRuleBuilder.editHttp().editFirstPath().withPath(ingressUrl.getPath())).endPath()).endHttp();
        }
        return ingressRuleBuilder.build();
    }

    private static void setOwnerReference(HasMetadata owner, List<HasMetadata> resources) {
        OwnerReference ownerReference = ((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)new OwnerReferenceBuilder().withName(owner.getMetadata().getName())).withApiVersion(owner.getApiVersion())).withUid(owner.getMetadata().getUid())).withKind(owner.getKind())).withController(Boolean.valueOf(true))).withBlockOwnerDeletion(Boolean.valueOf(true))).build();
        resources.forEach(resource -> resource.getMetadata().setOwnerReferences(Collections.singletonList(ownerReference)));
    }

    public static URL getIngressUrl(String ingressTemplate, String name, String namespace) {
        String template = IngressUtils.addProtocol(ingressTemplate);
        template = NAME_PTN.matcher(template).replaceAll(name);
        template = NAMESPACE_PTN.matcher(template).replaceAll(namespace);
        try {
            return new URL(template);
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage());
            throw new ReconciliationException(String.format("Unable to process the Ingress template(%s). Error: %s", ingressTemplate, e.getMessage()));
        }
    }

    private static String addProtocol(String url) {
        Preconditions.checkNotNull((Object)url);
        if (!URL_PROTOCOL_REGEX.matcher((CharSequence)url).find()) {
            url = "http://" + (String)url;
        }
        return url;
    }
}

