/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.highavailability.KubernetesHaServicesFactory;
import org.apache.flink.kubernetes.operator.api.spec.FlinkDeploymentSpec;
import org.apache.flink.kubernetes.operator.api.spec.FlinkVersion;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String CR_GENERATION_LABEL = "flinkdeployment.flink.apache.org/generation";

    public static Pod mergePodTemplates(Pod toPod, Pod fromPod) {
        if (fromPod == null) {
            return toPod;
        }
        if (toPod == null) {
            return fromPod;
        }
        JsonNode node1 = MAPPER.valueToTree((Object)toPod);
        JsonNode node2 = MAPPER.valueToTree((Object)fromPod);
        FlinkUtils.mergeInto(node1, node2);
        try {
            return (Pod)MAPPER.treeToValue((TreeNode)node1, Pod.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void mergeInto(JsonNode toNode, JsonNode fromNode) {
        Iterator fieldNames = fromNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode toChildNode = toNode.get(fieldName);
            JsonNode fromChildNode = fromNode.get(fieldName);
            if (toChildNode != null && toChildNode.isArray() && fromChildNode.isArray()) {
                for (int i = 0; i < fromChildNode.size(); ++i) {
                    JsonNode updatedChildNode = fromChildNode.get(i);
                    if (toChildNode.size() <= i) {
                        ((ArrayNode)toChildNode).add(updatedChildNode);
                    }
                    FlinkUtils.mergeInto(toChildNode.get(i), updatedChildNode);
                }
                continue;
            }
            if (toChildNode != null && toChildNode.isObject()) {
                FlinkUtils.mergeInto(toChildNode, fromChildNode);
                continue;
            }
            if (!(toNode instanceof ObjectNode)) continue;
            ((ObjectNode)toNode).replace(fieldName, fromChildNode);
        }
    }

    public static void deleteJobGraphInKubernetesHA(String clusterId, String namespace, KubernetesClient kubernetesClient) {
        Map haConfigMapLabels = KubernetesUtils.getConfigMapLabels((String)clusterId, (String)"high-availability");
        ConfigMapList configMaps = (ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(namespace)).withLabels(haConfigMapLabels)).list();
        boolean shouldUpdate = false;
        for (ConfigMap configMap : configMaps.getItems()) {
            boolean isDeleted;
            if (configMap.getData() == null || configMap.getData().isEmpty() || !(isDeleted = configMap.getData().entrySet().removeIf(FlinkUtils::isJobGraphKey))) continue;
            shouldUpdate = true;
            LOG.info("Job graph in ConfigMap {} is deleted", (Object)configMap.getMetadata().getName());
        }
        if (shouldUpdate) {
            ((ListVisitFromServerGetDeleteRecreateWaitApplicable)kubernetesClient.resourceList((KubernetesResourceList)configMaps).inNamespace(namespace)).createOrReplace();
        }
    }

    public static boolean isHaMetadataAvailable(Configuration conf, KubernetesClient kubernetesClient) {
        String clusterId = (String)conf.get(KubernetesConfigOptions.CLUSTER_ID);
        String namespace = (String)conf.get(KubernetesConfigOptions.NAMESPACE);
        Map haConfigMapLabels = KubernetesUtils.getConfigMapLabels((String)clusterId, (String)"high-availability");
        List configMaps = ((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(namespace)).withLabels(haConfigMapLabels)).list()).getItems();
        return configMaps.stream().anyMatch(Predicate.not(HasMetadata::isMarkedForDeletion));
    }

    private static boolean isJobGraphKey(Map.Entry<String, String> entry) {
        return entry.getKey().startsWith("jobGraph-");
    }

    public static boolean isKubernetesHAActivated(Configuration configuration) {
        String haMode = (String)configuration.get(HighAvailabilityOptions.HA_MODE);
        return haMode.equalsIgnoreCase(KubernetesHaServicesFactory.class.getCanonicalName()) || haMode.equalsIgnoreCase("kubernetes");
    }

    public static boolean clusterShutdownDisabled(FlinkDeploymentSpec spec) {
        return spec.getFlinkVersion().isNewerVersionThan(FlinkVersion.v1_14);
    }

    public static int getNumTaskManagers(Configuration conf) {
        int parallelism = (Integer)conf.get(CoreOptions.DEFAULT_PARALLELISM);
        return FlinkUtils.getNumTaskManagers(conf, parallelism);
    }

    public static int getNumTaskManagers(Configuration conf, int parallelism) {
        int taskSlots = (Integer)conf.get(TaskManagerOptions.NUM_TASK_SLOTS);
        return (parallelism + taskSlots - 1) / taskSlots;
    }

    public static void setGenerationAnnotation(Configuration conf, Long generation) {
        if (generation == null) {
            return;
        }
        HashMap<String, String> labels = new HashMap<String, String>(conf.getOptional(KubernetesConfigOptions.JOB_MANAGER_ANNOTATIONS).orElse(Collections.emptyMap()));
        labels.put(CR_GENERATION_LABEL, generation.toString());
        conf.set(KubernetesConfigOptions.JOB_MANAGER_ANNOTATIONS, labels);
    }

    public static JobID generateSessionJobFixedJobID(ObjectMeta meta) {
        return FlinkUtils.generateSessionJobFixedJobID(meta.getUid(), meta.getGeneration());
    }

    public static JobID generateSessionJobFixedJobID(String uid, Long generation) {
        return new JobID((long)((String)Preconditions.checkNotNull((Object)uid)).hashCode(), ((Long)Preconditions.checkNotNull((Object)generation)).longValue());
    }
}

