/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;
import org.apache.flink.kubernetes.operator.exception.DeploymentFailedException;
import org.apache.flink.kubernetes.operator.exception.FlinkResourceException;
import org.apache.flink.kubernetes.operator.exception.ReconciliationException;
import org.apache.flink.runtime.rest.util.RestClientException;
import org.apache.flink.util.Preconditions;

public final class FlinkResourceExceptionUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <R extends AbstractFlinkResource> void updateFlinkResourceException(Throwable throwable, R resource, FlinkOperatorConfiguration conf) {
        boolean stackTraceEnabled = conf.getExceptionStackTraceEnabled();
        int stackTraceLengthThreshold = conf.getExceptionStackTraceLengthThreshold();
        int lengthThreshold = conf.getExceptionFieldLengthThreshold();
        int throwableCountThreshold = conf.getExceptionThrowableCountThreshold();
        Preconditions.checkNotNull((Object)stackTraceEnabled);
        FlinkResourceException flinkResourceException = FlinkResourceExceptionUtils.getFlinkResourceException(throwable, stackTraceEnabled, stackTraceLengthThreshold, lengthThreshold, throwableCountThreshold);
        try {
            ((CommonStatus)resource.getStatus()).setError(FlinkResourceExceptionUtils.convertToJson(flinkResourceException));
        }
        catch (Exception e) {
            ((CommonStatus)resource.getStatus()).setError(e instanceof ReconciliationException ? e.getCause().toString() : e.toString());
        }
    }

    private static FlinkResourceException getFlinkResourceException(Throwable throwable, boolean isStackTraceEnabled, int stackTraceLengthThreshold, int lengthThreshold, int throwableCountThreshold) {
        FlinkResourceException flinkResourceException = FlinkResourceExceptionUtils.convertToFlinkResourceException(throwable, isStackTraceEnabled, stackTraceLengthThreshold, lengthThreshold);
        flinkResourceException.setThrowableList(ExceptionUtils.getThrowableList((Throwable)throwable.getCause()).stream().limit(throwableCountThreshold).map(t -> FlinkResourceExceptionUtils.convertToFlinkResourceException(t, false, stackTraceLengthThreshold, lengthThreshold)).collect(Collectors.toList()));
        return flinkResourceException;
    }

    private static FlinkResourceException convertToFlinkResourceException(Throwable throwable, boolean stackTraceEnabled, int stackTraceLengthThreshold, int lengthThreshold) {
        FlinkResourceException flinkResourceException = FlinkResourceException.builder().build();
        FlinkResourceExceptionUtils.getSubstringWithMaxLength(throwable.getClass().getName(), lengthThreshold).ifPresent(flinkResourceException::setType);
        FlinkResourceExceptionUtils.getSubstringWithMaxLength(throwable.getMessage(), lengthThreshold).ifPresent(flinkResourceException::setMessage);
        if (stackTraceEnabled) {
            FlinkResourceExceptionUtils.getSubstringWithMaxLength(ExceptionUtils.getStackTrace((Throwable)throwable), lengthThreshold).ifPresent(flinkResourceException::setStackTrace);
        }
        FlinkResourceExceptionUtils.enrichMetadata(throwable, flinkResourceException, lengthThreshold);
        return flinkResourceException;
    }

    public static Optional<String> getSubstringWithMaxLength(String str, int limit) {
        if (str == null) {
            return Optional.empty();
        }
        return Optional.of(str.substring(0, Math.min(str.length(), limit)));
    }

    private static void enrichMetadata(Throwable throwable, FlinkResourceException flinkResourceException, int lengthThreshold) {
        if (throwable instanceof RestClientException) {
            flinkResourceException.setAdditionalMetadata(Map.of("httpResponseCode", ((RestClientException)throwable).getHttpResponseStatus().code()));
        }
        if (throwable instanceof DeploymentFailedException) {
            FlinkResourceExceptionUtils.getSubstringWithMaxLength(((DeploymentFailedException)throwable).getReason(), lengthThreshold).ifPresent(reason -> flinkResourceException.setAdditionalMetadata(Map.of("reason", reason)));
        }
    }

    private static String convertToJson(FlinkResourceException flinkResourceException) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)flinkResourceException);
    }
}

