/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.time.Instant;
import java.util.function.Consumer;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;

public class EventUtils {
    public static String generateEventName(HasMetadata target, EventRecorder.Type type, String reason, String message, EventRecorder.Component component) {
        return component + "." + ((reason + message + type + target.getKind() + target.getMetadata().getName() + target.getMetadata().getUid()).hashCode() & Integer.MAX_VALUE);
    }

    public static boolean createOrUpdateEvent(KubernetesClient client, HasMetadata target, EventRecorder.Type type, String reason, String message, EventRecorder.Component component, Consumer<Event> eventListener) {
        String eventName = EventUtils.generateEventName(target, type, reason, message, component);
        Event existing = (Event)((Resource)((NonNamespaceOperation)client.v1().events().inNamespace(target.getMetadata().getNamespace())).withName(eventName)).get();
        if (existing != null && existing.getType().equals(type.name()) && existing.getReason().equals(reason) && existing.getInvolvedObject().getName().equals(target.getMetadata().getName()) && existing.getInvolvedObject().getKind().equals(target.getKind())) {
            existing.setLastTimestamp(Instant.now().toString());
            existing.setCount(Integer.valueOf(existing.getCount() + 1));
            existing.setMessage(message);
            client.resource((HasMetadata)existing).createOrReplace();
            eventListener.accept(existing);
            return false;
        }
        Event event = ((EventBuilder)((EventFluent.MetadataNested)((EventFluent.MetadataNested)((EventBuilder)((EventBuilder)((EventBuilder)((EventFluent.SourceNested)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)new EventBuilder().withApiVersion("v1")).withInvolvedObject(((ObjectReferenceBuilder)((ObjectReferenceBuilder)((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind(target.getKind())).withUid(target.getMetadata().getUid())).withName(target.getMetadata().getName())).withNamespace(target.getMetadata().getNamespace())).build())).withType(type.name())).withReason(reason)).withFirstTimestamp(Instant.now().toString())).withLastTimestamp(Instant.now().toString())).withNewSource().withComponent(component.name())).endSource()).withCount(Integer.valueOf(1))).withMessage(message)).withNewMetadata().withName(eventName)).withNamespace(target.getMetadata().getNamespace())).endMetadata()).build();
        client.resource((HasMetadata)event).createOrReplace();
        eventListener.accept(event);
        return true;
    }
}

