/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.listener.FlinkResourceListener;
import org.apache.flink.kubernetes.operator.listener.AuditUtils;
import org.apache.flink.kubernetes.operator.utils.EventUtils;

public class EventRecorder {
    private final KubernetesClient client;
    private final BiConsumer<AbstractFlinkResource<?, ?>, Event> eventListener;

    public EventRecorder(KubernetesClient client, BiConsumer<AbstractFlinkResource<?, ?>, Event> eventListener) {
        this.client = client;
        this.eventListener = eventListener;
    }

    public boolean triggerEvent(AbstractFlinkResource<?, ?> resource, Type type, Reason reason, Component component, String message) {
        return this.triggerEvent(resource, type, reason.toString(), message, component);
    }

    public boolean triggerEvent(AbstractFlinkResource<?, ?> resource, Type type, String reason, String message, Component component) {
        return EventUtils.createOrUpdateEvent(this.client, resource, type, reason, message, component, e -> this.eventListener.accept(resource, (Event)e));
    }

    public static EventRecorder create(KubernetesClient client, Collection<FlinkResourceListener> listeners) {
        BiConsumer<AbstractFlinkResource<?, ?>, Event> biConsumer = (resource, event) -> {
            FlinkResourceListener.ResourceEventContext ctx = new FlinkResourceListener.ResourceEventContext((Event)event, (AbstractFlinkResource)resource, client){
                final /* synthetic */ Event val$event;
                final /* synthetic */ AbstractFlinkResource val$resource;
                final /* synthetic */ KubernetesClient val$client;
                {
                    this.val$event = event;
                    this.val$resource = abstractFlinkResource;
                    this.val$client = kubernetesClient;
                }

                public Event getEvent() {
                    return this.val$event;
                }

                public AbstractFlinkResource<?, ?> getFlinkResource() {
                    return this.val$resource;
                }

                public KubernetesClient getKubernetesClient() {
                    return this.val$client;
                }
            };
            listeners.forEach(arg_0 -> EventRecorder.lambda$create$1(resource, ctx, arg_0));
            AuditUtils.logContext(ctx);
        };
        return new EventRecorder(client, biConsumer);
    }

    private static /* synthetic */ void lambda$create$1(AbstractFlinkResource resource, 1 ctx, FlinkResourceListener listener) {
        if (resource instanceof FlinkDeployment) {
            listener.onDeploymentEvent((FlinkResourceListener.ResourceEventContext)ctx);
        } else {
            listener.onSessionJobEvent((FlinkResourceListener.ResourceEventContext)ctx);
        }
    }

    public static enum Reason {
        Suspended,
        SpecChanged,
        Rollback,
        Submit,
        JobStatusChanged,
        SavepointError,
        Cleanup,
        CleanupFailed,
        Missing,
        ValidationError,
        RecoverDeployment,
        RestartUnhealthyJob;

    }

    public static enum Component {
        Operator,
        JobManagerDeployment,
        Job;

    }

    public static enum Type {
        Normal,
        Warning;

    }
}

