/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.ssl;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http2.Http2SecurityUtil;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.CipherSuiteFilter;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslContext;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslContextBuilder;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SupportedCipherSuiteFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadableSslContext
extends SslContext {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadableSslContext.class);
    private final String keystorePath;
    private final String keystoreType;
    private final String keystorePassword;
    private volatile SslContext sslContext;

    public ReloadableSslContext(String keystorePath, String keystoreType, String keystorePassword) throws Exception {
        this.keystorePath = keystorePath;
        this.keystoreType = keystoreType;
        this.keystorePassword = keystorePassword;
        this.loadContext();
    }

    public boolean isClient() {
        return this.sslContext.isClient();
    }

    public List<String> cipherSuites() {
        return this.sslContext.cipherSuites();
    }

    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.sslContext.applicationProtocolNegotiator();
    }

    public SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.sslContext.newEngine(byteBufAllocator);
    }

    public SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String s, int i) {
        return this.sslContext.newEngine(byteBufAllocator, s, i);
    }

    public SSLSessionContext sessionContext() {
        return this.sslContext.sessionContext();
    }

    public void reload() throws Exception {
        this.loadContext();
    }

    private void loadContext() throws Exception {
        LOG.info("Creating keystore with type: " + this.keystoreType);
        KeyStore keyStore = KeyStore.getInstance(this.keystoreType);
        LOG.info("Loading keystore from file: " + this.keystorePath);
        try (InputStream keyStoreFile = Files.newInputStream(new File(this.keystorePath).toPath(), new OpenOption[0]);){
            keyStore.load(keyStoreFile, this.keystorePassword.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        LOG.info("Initializing key manager with keystore and password");
        kmf.init(keyStore, this.keystorePassword.toCharArray());
        this.sslContext = SslContextBuilder.forServer((KeyManagerFactory)kmf).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).build();
    }
}

