/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.service;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.service.FlinkService;
import org.apache.flink.kubernetes.operator.service.NativeFlinkService;
import org.apache.flink.kubernetes.operator.service.StandaloneFlinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkServiceFactory {
    private final KubernetesClient kubernetesClient;
    private final FlinkConfigManager configManager;
    private final Map<KubernetesDeploymentMode, FlinkService> serviceMap;
    private static final Logger LOG = LoggerFactory.getLogger(FlinkServiceFactory.class);

    public FlinkServiceFactory(KubernetesClient kubernetesClient, FlinkConfigManager configManager) {
        this.kubernetesClient = kubernetesClient;
        this.configManager = configManager;
        this.serviceMap = new ConcurrentHashMap<KubernetesDeploymentMode, FlinkService>();
    }

    public FlinkService getOrCreate(KubernetesDeploymentMode deploymentMode) {
        return this.serviceMap.computeIfAbsent(deploymentMode, mode -> {
            switch (mode) {
                case NATIVE: {
                    LOG.info("Using NativeFlinkService");
                    return new NativeFlinkService(this.kubernetesClient, this.configManager);
                }
                case STANDALONE: {
                    LOG.info("Using StandaloneFlinkService");
                    return new StandaloneFlinkService(this.kubernetesClient, this.configManager);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported deployment mode: %s", mode));
        });
    }

    public FlinkService getOrCreate(FlinkDeployment deployment) {
        LOG.info("Getting service for {}", (Object)deployment.getMetadata().getName());
        return this.getOrCreate(this.getDeploymentMode(deployment));
    }

    private KubernetesDeploymentMode getDeploymentMode(FlinkDeployment deployment) {
        return KubernetesDeploymentMode.getDeploymentMode((FlinkDeployment)deployment);
    }
}

