/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.service;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.api.spec.JobSpec;
import org.apache.flink.kubernetes.operator.api.spec.UpgradeMode;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.Savepoint;
import org.apache.flink.kubernetes.operator.api.status.SavepointInfo;
import org.apache.flink.kubernetes.operator.api.status.SavepointTriggerType;
import org.apache.flink.kubernetes.operator.observer.SavepointFetchResult;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.jobmaster.JobResult;

public interface FlinkService {
    public KubernetesClient getKubernetesClient();

    public void submitApplicationCluster(JobSpec var1, Configuration var2, boolean var3) throws Exception;

    public boolean isHaMetadataAvailable(Configuration var1);

    public void submitSessionCluster(Configuration var1) throws Exception;

    public JobID submitJobToSessionCluster(ObjectMeta var1, FlinkSessionJobSpec var2, Configuration var3, @Nullable String var4) throws Exception;

    public boolean isJobManagerPortReady(Configuration var1);

    public Collection<JobStatusMessage> listJobs(Configuration var1) throws Exception;

    public JobResult requestJobResult(Configuration var1, JobID var2) throws Exception;

    public void cancelJob(FlinkDeployment var1, UpgradeMode var2, Configuration var3) throws Exception;

    public void deleteClusterDeployment(ObjectMeta var1, FlinkDeploymentStatus var2, boolean var3);

    public void cancelSessionJob(FlinkSessionJob var1, UpgradeMode var2, Configuration var3) throws Exception;

    public void triggerSavepoint(String var1, SavepointTriggerType var2, SavepointInfo var3, Configuration var4) throws Exception;

    public Optional<Savepoint> getLastCheckpoint(JobID var1, Configuration var2) throws Exception;

    public SavepointFetchResult fetchSavepointInfo(String var1, String var2, Configuration var3);

    public void disposeSavepoint(String var1, Configuration var2) throws Exception;

    public Map<String, String> getClusterInfo(Configuration var1) throws Exception;

    public PodList getJmPodList(FlinkDeployment var1, Configuration var2);

    public void waitForClusterShutdown(Configuration var1);

    default public boolean scale(ObjectMeta meta, JobSpec jobSpec, Configuration conf) {
        return false;
    }

    public Map<String, String> getMetrics(Configuration var1, String var2, List<String> var3) throws Exception;
}

