/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.service;

import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CheckpointHistoryWrapper
implements ResponseBody {
    @JsonProperty(value="latest")
    private ObjectNode latestCheckpoints;

    public Optional<String> getLatestCheckpointPath() {
        if (this.latestCheckpoints == null) {
            return Optional.empty();
        }
        Tuple2 latestCheckpoint = this.getCheckpointInfo("restored").orElse(null);
        Tuple2 completed = this.getCheckpointInfo("completed").orElse(null);
        if (latestCheckpoint == null || completed != null && (Long)completed.f0 > (Long)latestCheckpoint.f0) {
            latestCheckpoint = completed;
        }
        Tuple2 savepoint = this.getCheckpointInfo("savepoint").orElse(null);
        if (latestCheckpoint == null || savepoint != null && (Long)savepoint.f0 > (Long)latestCheckpoint.f0) {
            latestCheckpoint = savepoint;
        }
        return Optional.ofNullable(latestCheckpoint).map(t -> (String)t.f1);
    }

    private Optional<Tuple2<Long, String>> getCheckpointInfo(String field) {
        return Optional.ofNullable(this.latestCheckpoints.get(field)).filter(checkpoint -> checkpoint.has("id") && checkpoint.has("external_path")).map(checkpoint -> Tuple2.of((Object)checkpoint.get("id").asLong(), (Object)checkpoint.get("external_path").asText()));
    }

    public ObjectNode getLatestCheckpoints() {
        return this.latestCheckpoints;
    }

    public void setLatestCheckpoints(ObjectNode latestCheckpoints) {
        this.latestCheckpoints = latestCheckpoints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckpointHistoryWrapper)) {
            return false;
        }
        CheckpointHistoryWrapper other = (CheckpointHistoryWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectNode this$latestCheckpoints = this.getLatestCheckpoints();
        ObjectNode other$latestCheckpoints = other.getLatestCheckpoints();
        return !(this$latestCheckpoints == null ? other$latestCheckpoints != null : !this$latestCheckpoints.equals(other$latestCheckpoints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckpointHistoryWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectNode $latestCheckpoints = this.getLatestCheckpoints();
        result = result * 59 + ($latestCheckpoints == null ? 43 : $latestCheckpoints.hashCode());
        return result;
    }

    public String toString() {
        return "CheckpointHistoryWrapper(latestCheckpoints=" + this.getLatestCheckpoints() + ")";
    }
}

