/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.reconciler.diff;

import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.diff.DiffType;
import org.apache.flink.kubernetes.operator.reconciler.diff.Diff;

@Experimental
public class DiffResult<T> {
    @NonNull
    private final List<Diff<?>> diffList;
    @NonNull
    private final T left;
    @NonNull
    private final T right;
    @NonNull
    private final DiffType type;

    DiffResult(@NonNull T left, @NonNull T right, @NonNull List<Diff<?>> diffList) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        if (diffList == null) {
            throw new NullPointerException("diffList is marked non-null but is null");
        }
        this.left = left;
        this.right = right;
        this.diffList = diffList;
        this.type = DiffResult.getSpechChangeType(diffList);
    }

    public int getNumDiffs() {
        return this.diffList.size();
    }

    public String toString() {
        if (this.diffList.isEmpty()) {
            return "";
        }
        ToStringBuilder lhsBuilder = new ToStringBuilder(this.left, ToStringStyle.SHORT_PREFIX_STYLE);
        ToStringBuilder rhsBuilder = new ToStringBuilder(this.right, ToStringStyle.SHORT_PREFIX_STYLE);
        this.diffList.forEach(diff -> {
            lhsBuilder.append(diff.getFieldName(), diff.getLeft());
            rhsBuilder.append(diff.getFieldName(), diff.getRight());
        });
        return String.format("%s differs from %s", lhsBuilder.build(), rhsBuilder.build());
    }

    private static DiffType getSpechChangeType(List<Diff<?>> diffs) {
        DiffType type = DiffType.IGNORE;
        for (Diff<?> diff : diffs) {
            if ((type = DiffType.max((DiffType)type, (DiffType)diff.getType())) != DiffType.UPGRADE) continue;
            return type;
        }
        return type;
    }

    @NonNull
    public List<Diff<?>> getDiffList() {
        return this.diffList;
    }

    @NonNull
    public T getLeft() {
        return this.left;
    }

    @NonNull
    public T getRight() {
        return this.right;
    }

    @NonNull
    public DiffType getType() {
        return this.type;
    }
}

