/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.reconciler.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.builder.Builder;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.diff.DiffType;
import org.apache.flink.kubernetes.operator.reconciler.diff.Diff;
import org.apache.flink.kubernetes.operator.reconciler.diff.DiffResult;

@Experimental
public class DiffBuilder<T>
implements Builder<DiffResult<?>> {
    private static final String DELIMITER = ".";
    private final T left;
    private final T right;
    private final List<Diff<?>> diffs;
    private boolean triviallyEqual;

    public DiffBuilder(@NonNull T left, @NonNull T right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        this.diffs = new ArrayList();
        this.left = left;
        this.right = right;
        this.triviallyEqual = left == right || left.equals(right);
    }

    public DiffBuilder<T> testTriviallyEqual(boolean testTriviallyEqual) {
        this.triviallyEqual = this.triviallyEqual && testTriviallyEqual;
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, boolean left, boolean right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (left != right) {
            this.diffs.add(new Diff<Boolean>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, boolean[] left, boolean[] right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!Arrays.equals(left, right)) {
            this.diffs.add(new Diff<boolean[]>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, byte left, byte right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (left != right) {
            this.diffs.add(new Diff<Byte>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, byte[] left, byte[] right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!Arrays.equals(left, right)) {
            this.diffs.add(new Diff<byte[]>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, char left, char right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (left != right) {
            this.diffs.add(new Diff<Character>(fieldName, Character.valueOf(left), Character.valueOf(right), type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, char[] left, char[] right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!Arrays.equals(left, right)) {
            this.diffs.add(new Diff<char[]>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, double left, double right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (Double.doubleToLongBits(left) != Double.doubleToLongBits(right)) {
            this.diffs.add(new Diff<Double>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, double[] left, double[] right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!Arrays.equals(left, right)) {
            this.diffs.add(new Diff<double[]>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, float left, float right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (Float.floatToIntBits(left) != Float.floatToIntBits(right)) {
            this.diffs.add(new Diff<Float>(fieldName, Float.valueOf(left), Float.valueOf(right), type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, float[] left, float[] right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!Arrays.equals(left, right)) {
            this.diffs.add(new Diff<float[]>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, int left, int right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (left != right) {
            this.diffs.add(new Diff<Integer>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, int[] left, int[] right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!Arrays.equals(left, right)) {
            this.diffs.add(new Diff<int[]>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, long left, long right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (left != right) {
            this.diffs.add(new Diff<Long>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, long[] left, long[] right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!Arrays.equals(left, right)) {
            this.diffs.add(new Diff<long[]>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, short left, short right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (left != right) {
            this.diffs.add(new Diff<Short>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, short[] left, short[] right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!Arrays.equals(left, right)) {
            this.diffs.add(new Diff<short[]>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, Object left, Object right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (left == right) {
            return this;
        }
        Object objectToTest = Objects.requireNonNullElse(left, right);
        if (objectToTest.getClass().isArray()) {
            if (objectToTest instanceof boolean[]) {
                return this.append(fieldName, (boolean[])left, (boolean[])right, type);
            }
            if (objectToTest instanceof byte[]) {
                return this.append(fieldName, (byte[])left, (byte[])right, type);
            }
            if (objectToTest instanceof char[]) {
                return this.append(fieldName, (char[])left, (char[])right, type);
            }
            if (objectToTest instanceof double[]) {
                return this.append(fieldName, (double[])left, (double[])right, type);
            }
            if (objectToTest instanceof float[]) {
                return this.append(fieldName, (float[])left, (float[])right, type);
            }
            if (objectToTest instanceof int[]) {
                return this.append(fieldName, (int[])left, (int[])right, type);
            }
            if (objectToTest instanceof long[]) {
                return this.append(fieldName, (long[])left, (long[])right, type);
            }
            if (objectToTest instanceof short[]) {
                return this.append(fieldName, (short[])left, (short[])right, type);
            }
            return this.append(fieldName, (Object[])left, (Object[])right, type);
        }
        if (left != null && left.equals(right)) {
            return this;
        }
        this.diffs.add(new Diff<Object>(fieldName, left, right, type));
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, Object[] left, Object[] right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!Arrays.equals(left, right)) {
            this.diffs.add(new Diff<Object[]>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, @NonNull DiffResult<?> diffResult) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (diffResult == null) {
            throw new NullPointerException("diffResult is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        diffResult.getDiffList().forEach(diff -> this.append(fieldName + DELIMITER + diff.getFieldName(), diff.getLeft(), diff.getRight(), diff.getType()));
        return this;
    }

    public DiffResult<T> build() {
        return new DiffResult<T>(this.left, this.right, this.diffs);
    }
}

