/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.reconciler.deployment;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.config.Mode;
import org.apache.flink.kubernetes.operator.reconciler.Reconciler;
import org.apache.flink.kubernetes.operator.reconciler.deployment.ApplicationReconciler;
import org.apache.flink.kubernetes.operator.reconciler.deployment.SessionReconciler;
import org.apache.flink.kubernetes.operator.service.FlinkServiceFactory;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.StatusRecorder;

public class ReconcilerFactory {
    private final KubernetesClient kubernetesClient;
    private final FlinkServiceFactory flinkServiceFactory;
    private final FlinkConfigManager configManager;
    private final EventRecorder eventRecorder;
    private final StatusRecorder<FlinkDeployment, FlinkDeploymentStatus> deploymentStatusRecorder;
    private final Map<Tuple2<Mode, KubernetesDeploymentMode>, Reconciler<FlinkDeployment>> reconcilerMap;

    public ReconcilerFactory(KubernetesClient kubernetesClient, FlinkServiceFactory flinkServiceFactory, FlinkConfigManager configManager, EventRecorder eventRecorder, StatusRecorder<FlinkDeployment, FlinkDeploymentStatus> deploymentStatusRecorder) {
        this.kubernetesClient = kubernetesClient;
        this.flinkServiceFactory = flinkServiceFactory;
        this.configManager = configManager;
        this.eventRecorder = eventRecorder;
        this.deploymentStatusRecorder = deploymentStatusRecorder;
        this.reconcilerMap = new ConcurrentHashMap<Tuple2<Mode, KubernetesDeploymentMode>, Reconciler<FlinkDeployment>>();
    }

    public Reconciler<FlinkDeployment> getOrCreate(FlinkDeployment flinkApp) {
        return this.reconcilerMap.computeIfAbsent((Tuple2<Mode, KubernetesDeploymentMode>)Tuple2.of((Object)((Object)Mode.getMode(flinkApp)), (Object)KubernetesDeploymentMode.getDeploymentMode((FlinkDeployment)flinkApp)), modes -> {
            switch ((Mode)((Object)((Object)modes.f0))) {
                case SESSION: {
                    return new SessionReconciler(this.kubernetesClient, this.flinkServiceFactory.getOrCreate(flinkApp), this.configManager, this.eventRecorder, this.deploymentStatusRecorder);
                }
                case APPLICATION: {
                    return new ApplicationReconciler(this.kubernetesClient, this.flinkServiceFactory.getOrCreate(flinkApp), this.configManager, this.eventRecorder, this.deploymentStatusRecorder);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported running mode: %s", modes.f0));
        });
    }
}

