/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer.sessionjob;

import io.javaoperatorsdk.operator.api.reconciler.Context;
import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.observer.ObserverContext;
import org.apache.flink.kubernetes.operator.reconciler.sessionjob.SessionJobReconciler;
import org.apache.flink.kubernetes.operator.service.FlinkService;
import org.apache.flink.kubernetes.operator.service.FlinkServiceFactory;

public final class FlinkSessionJobObserverContext
implements ObserverContext {
    private final boolean readyToReconcile;
    private final FlinkService flinkService;
    private final Configuration deployedConfig;

    public FlinkSessionJobObserverContext(FlinkSessionJob resource, Context<?> resourceContext, FlinkServiceFactory flinkServiceFactory, FlinkConfigManager configManager) {
        Optional flinkDepOpt = resourceContext.getSecondaryResource(FlinkDeployment.class);
        this.readyToReconcile = SessionJobReconciler.sessionClusterReady(flinkDepOpt);
        if (this.readyToReconcile) {
            FlinkDeployment flinkDeployment = (FlinkDeployment)flinkDepOpt.get();
            this.flinkService = flinkServiceFactory.getOrCreate(flinkDeployment);
            this.deployedConfig = configManager.getSessionJobConfig(flinkDeployment, (FlinkSessionJobSpec)resource.getSpec());
        } else {
            this.flinkService = null;
            this.deployedConfig = null;
        }
    }

    public boolean isReadyToReconcile() {
        return this.readyToReconcile;
    }

    public FlinkService getFlinkService() {
        return this.flinkService;
    }

    @Override
    public Configuration getDeployedConfig() {
        return this.deployedConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkSessionJobObserverContext)) {
            return false;
        }
        FlinkSessionJobObserverContext other = (FlinkSessionJobObserverContext)o;
        if (this.isReadyToReconcile() != other.isReadyToReconcile()) {
            return false;
        }
        FlinkService this$flinkService = this.getFlinkService();
        FlinkService other$flinkService = other.getFlinkService();
        if (this$flinkService == null ? other$flinkService != null : !this$flinkService.equals(other$flinkService)) {
            return false;
        }
        Configuration this$deployedConfig = this.getDeployedConfig();
        Configuration other$deployedConfig = other.getDeployedConfig();
        return !(this$deployedConfig == null ? other$deployedConfig != null : !this$deployedConfig.equals(other$deployedConfig));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReadyToReconcile() ? 79 : 97);
        FlinkService $flinkService = this.getFlinkService();
        result = result * 59 + ($flinkService == null ? 43 : $flinkService.hashCode());
        Configuration $deployedConfig = this.getDeployedConfig();
        result = result * 59 + ($deployedConfig == null ? 43 : $deployedConfig.hashCode());
        return result;
    }

    public String toString() {
        return "FlinkSessionJobObserverContext(readyToReconcile=" + this.isReadyToReconcile() + ", flinkService=" + this.getFlinkService() + ", deployedConfig=" + this.getDeployedConfig() + ")";
    }
}

