/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer.deployment;

import io.javaoperatorsdk.operator.api.reconciler.Context;
import java.util.concurrent.TimeoutException;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentReconciliationStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationState;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.observer.deployment.AbstractFlinkDeploymentObserver;
import org.apache.flink.kubernetes.operator.observer.deployment.FlinkDeploymentObserverContext;
import org.apache.flink.kubernetes.operator.service.FlinkService;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;

public class SessionObserver
extends AbstractFlinkDeploymentObserver {
    public SessionObserver(FlinkService flinkService, FlinkConfigManager configManager, EventRecorder eventRecorder) {
        super(flinkService, configManager, eventRecorder);
    }

    @Override
    public void observeFlinkCluster(FlinkDeployment deployment, Context<?> context, FlinkDeploymentObserverContext observerContext) {
        block3: {
            try {
                this.logger.debug("Observing session cluster");
                this.flinkService.listJobs(observerContext.getDeployedConfig());
                FlinkDeploymentReconciliationStatus rs = ((FlinkDeploymentStatus)deployment.getStatus()).getReconciliationStatus();
                if (rs.getState() == ReconciliationState.DEPLOYED) {
                    rs.markReconciledSpecAsStable();
                }
            }
            catch (Exception e) {
                this.logger.error("REST service in session cluster is bad now", (Throwable)e);
                if (!(e instanceof TimeoutException)) break block3;
                this.observeJmDeployment(deployment, context, observerContext.getDeployedConfig());
            }
        }
    }
}

