/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer.deployment;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.config.Mode;
import org.apache.flink.kubernetes.operator.observer.Observer;
import org.apache.flink.kubernetes.operator.observer.deployment.ApplicationObserver;
import org.apache.flink.kubernetes.operator.observer.deployment.SessionObserver;
import org.apache.flink.kubernetes.operator.service.FlinkServiceFactory;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.StatusRecorder;

public class FlinkDeploymentObserverFactory {
    private final FlinkServiceFactory flinkServiceFactory;
    private final FlinkConfigManager configManager;
    private final StatusRecorder<FlinkDeployment, FlinkDeploymentStatus> statusRecorder;
    private final EventRecorder eventRecorder;
    private final Map<Tuple2<Mode, KubernetesDeploymentMode>, Observer<FlinkDeployment>> observerMap;

    public FlinkDeploymentObserverFactory(FlinkServiceFactory flinkServiceFactory, FlinkConfigManager configManager, StatusRecorder<FlinkDeployment, FlinkDeploymentStatus> statusRecorder, EventRecorder eventRecorder) {
        this.flinkServiceFactory = flinkServiceFactory;
        this.configManager = configManager;
        this.statusRecorder = statusRecorder;
        this.eventRecorder = eventRecorder;
        this.observerMap = new ConcurrentHashMap<Tuple2<Mode, KubernetesDeploymentMode>, Observer<FlinkDeployment>>();
    }

    public Observer<FlinkDeployment> getOrCreate(FlinkDeployment flinkApp) {
        return this.observerMap.computeIfAbsent((Tuple2<Mode, KubernetesDeploymentMode>)Tuple2.of((Object)((Object)Mode.getMode(flinkApp)), (Object)KubernetesDeploymentMode.getDeploymentMode((FlinkDeployment)flinkApp)), modes -> {
            switch ((Mode)((Object)((Object)modes.f0))) {
                case SESSION: {
                    return new SessionObserver(this.flinkServiceFactory.getOrCreate(flinkApp), this.configManager, this.eventRecorder);
                }
                case APPLICATION: {
                    return new ApplicationObserver(this.flinkServiceFactory.getOrCreate(flinkApp), this.configManager, this.eventRecorder);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported running mode: %s", modes.f0));
        });
    }
}

