/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer.deployment;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.observer.ObserverContext;

public final class FlinkDeploymentObserverContext
implements ObserverContext {
    private final Configuration deployedConfig;

    protected FlinkDeploymentObserverContext(FlinkDeployment resource, FlinkConfigManager configManager) {
        this.deployedConfig = ((FlinkDeploymentStatus)resource.getStatus()).getReconciliationStatus().isBeforeFirstDeployment() ? null : configManager.getObserveConfig(resource);
    }

    @Override
    public Configuration getDeployedConfig() {
        return this.deployedConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkDeploymentObserverContext)) {
            return false;
        }
        FlinkDeploymentObserverContext other = (FlinkDeploymentObserverContext)o;
        Configuration this$deployedConfig = this.getDeployedConfig();
        Configuration other$deployedConfig = other.getDeployedConfig();
        return !(this$deployedConfig == null ? other$deployedConfig != null : !this$deployedConfig.equals(other$deployedConfig));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Configuration $deployedConfig = this.getDeployedConfig();
        result = result * 59 + ($deployedConfig == null ? 43 : $deployedConfig.hashCode());
        return result;
    }

    public String toString() {
        return "FlinkDeploymentObserverContext(deployedConfig=" + this.getDeployedConfig() + ")";
    }
}

