/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer.deployment;

import io.javaoperatorsdk.operator.api.reconciler.Context;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.apache.flink.kubernetes.operator.exception.UnknownJobException;
import org.apache.flink.kubernetes.operator.observer.ClusterHealthObserver;
import org.apache.flink.kubernetes.operator.observer.JobStatusObserver;
import org.apache.flink.kubernetes.operator.observer.SavepointObserver;
import org.apache.flink.kubernetes.operator.observer.deployment.AbstractFlinkDeploymentObserver;
import org.apache.flink.kubernetes.operator.observer.deployment.FlinkDeploymentObserverContext;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.operator.service.FlinkService;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.runtime.client.JobStatusMessage;

public class ApplicationObserver
extends AbstractFlinkDeploymentObserver {
    private final SavepointObserver<FlinkDeployment, FlinkDeploymentStatus> savepointObserver;
    private final JobStatusObserver<FlinkDeployment, FlinkDeploymentObserverContext> jobStatusObserver;
    private final ClusterHealthObserver clusterHealthObserver;

    public ApplicationObserver(FlinkService flinkService, FlinkConfigManager configManager, EventRecorder eventRecorder) {
        super(flinkService, configManager, eventRecorder);
        this.savepointObserver = new SavepointObserver(flinkService, configManager, eventRecorder);
        this.jobStatusObserver = new ApplicationJobObserver(flinkService, configManager, eventRecorder);
        this.clusterHealthObserver = new ClusterHealthObserver(flinkService);
    }

    @Override
    protected void observeFlinkCluster(FlinkDeployment flinkApp, Context<?> context, FlinkDeploymentObserverContext observerContext) {
        this.logger.debug("Observing application cluster");
        boolean jobFound = this.jobStatusObserver.observe(flinkApp, context, observerContext);
        if (jobFound) {
            Configuration deployedConfig = observerContext.getDeployedConfig();
            this.savepointObserver.observeSavepointStatus(flinkApp, deployedConfig);
            if (deployedConfig.getBoolean(KubernetesOperatorConfigOptions.OPERATOR_CLUSTER_HEALTH_CHECK_ENABLED)) {
                this.clusterHealthObserver.observe(flinkApp, deployedConfig);
            }
        }
    }

    private class ApplicationJobObserver
    extends JobStatusObserver<FlinkDeployment, FlinkDeploymentObserverContext> {
        public ApplicationJobObserver(FlinkService flinkService, FlinkConfigManager configManager, EventRecorder eventRecorder) {
            super(flinkService, configManager, eventRecorder);
        }

        @Override
        public void onTimeout(FlinkDeployment flinkDep, Context<?> context, FlinkDeploymentObserverContext observerContext) {
            ApplicationObserver.this.observeJmDeployment(flinkDep, context, observerContext.getDeployedConfig());
        }

        @Override
        protected Optional<JobStatusMessage> filterTargetJob(org.apache.flink.kubernetes.operator.api.status.JobStatus status, List<JobStatusMessage> clusterJobStatuses) {
            if (!clusterJobStatuses.isEmpty()) {
                return Optional.of(clusterJobStatuses.get(0));
            }
            return Optional.empty();
        }

        @Override
        protected void onTargetJobNotFound(FlinkDeployment resource, Configuration config) {
            this.setUnknownJobError(resource);
        }

        private void setUnknownJobError(FlinkDeployment deployment) {
            ((FlinkDeploymentStatus)deployment.getStatus()).getJobStatus().setState(JobStatus.RECONCILING.name());
            String err = "Unrecognized Job for Application deployment";
            ApplicationObserver.this.logger.error(err);
            ReconciliationUtils.updateForReconciliationError(deployment, new UnknownJobException(err), this.configManager.getOperatorConfiguration());
            this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)deployment, EventRecorder.Type.Warning, EventRecorder.Reason.Missing, EventRecorder.Component.Job, err);
        }
    }
}

